/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.table.ui;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.user.client.FocusCommand;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.TextBoxNumberFilter;
import org.xwiki.gwt.user.client.ui.wizard.AbstractInteractiveWizardStep;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.table.TableDescriptor;

public class TableConfigWizardStep
extends AbstractInteractiveWizardStep
implements KeyUpHandler,
SourcesNavigationEvents {
    private static final String DEFAULT_PANEL_STYLE = "xTablePanel";
    private static final String INFO_LABEL_STYLE = "xInfoLabel";
    private static final String MANDATORY_STYLE = "xMandatory";
    private static final String HELP_LABEL_STYLE = "xHelpLabel";
    private static final String ERROR_STYLE = "xErrorMsg";
    private static final String FIELD_ERROR_STYLE = "xErrorField";
    private TextBox rows;
    private Label rowsValidationMessage;
    private TextBox columns;
    private Label columnsValidationMessage;
    private TextBox border;
    private CheckBox header;
    private final TableDescriptor descriptor;
    private final NavigationListenerCollection navigationListeners = new NavigationListenerCollection();

    public TableConfigWizardStep() {
        this.setStepTitle(Strings.INSTANCE.tableInsertDialogTitle());
        this.descriptor = new TableDescriptor();
        this.descriptor.setRowCount(2);
        this.descriptor.setColumnCount(2);
        this.descriptor.setWithHeader(true);
        this.display().addStyleName("xTableMainPanel");
        this.display().add((Widget)this.getRowsPanel());
        this.display().add((Widget)this.getColumnsPanel());
        this.display().add((Widget)this.getHeaderPanel());
    }

    public void onKeyUp(KeyUpEvent event) {
        if (event.getNativeKeyCode() == 13) {
            this.navigationListeners.fireNavigationEvent(NavigationListener.NavigationDirection.NEXT);
        }
    }

    public Object getResult() {
        return this.descriptor;
    }

    public void init(Object data, AsyncCallback<?> cb) {
        cb.onSuccess(null);
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new FocusCommand((Focusable)this.rows));
    }

    public void onCancel() {
        this.hideValidationMessages();
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        if (this.validate()) {
            this.updateTableDescriptor();
            async.onSuccess((Object)true);
        } else {
            async.onSuccess((Object)false);
        }
    }

    public void addNavigationListener(NavigationListener listener) {
        this.navigationListeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.navigationListeners.remove((Object)listener);
    }

    private Panel getRowsPanel() {
        FlowPanel panel = new FlowPanel();
        panel.addStyleName(DEFAULT_PANEL_STYLE);
        FlowPanel rowsLabel = new FlowPanel();
        rowsLabel.setStyleName(INFO_LABEL_STYLE);
        rowsLabel.add((Widget)new InlineLabel(Strings.INSTANCE.tableRowsLabel()));
        InlineLabel mandatoryLabel = new InlineLabel(Strings.INSTANCE.mandatory());
        mandatoryLabel.addStyleName(MANDATORY_STYLE);
        rowsLabel.add((Widget)mandatoryLabel);
        panel.add((Widget)rowsLabel);
        Label rowsHelpLabel = new Label(Strings.INSTANCE.tableRowsHelpLabel());
        rowsHelpLabel.setStyleName(HELP_LABEL_STYLE);
        panel.add((Widget)rowsHelpLabel);
        this.rowsValidationMessage = new Label(Strings.INSTANCE.tableInsertStrictPositiveIntegerRequired());
        this.rowsValidationMessage.setVisible(false);
        this.rowsValidationMessage.addStyleName(ERROR_STYLE);
        panel.add((Widget)this.rowsValidationMessage);
        this.rows = new TextBox();
        this.rows.setText(String.valueOf(this.descriptor.getRowCount()));
        this.rows.setTitle(Strings.INSTANCE.tableRowsToolTip());
        this.rows.addKeyPressHandler((KeyPressHandler)new TextBoxNumberFilter());
        this.rows.addKeyUpHandler((KeyUpHandler)this);
        panel.add((Widget)this.rows);
        return panel;
    }

    private Panel getColumnsPanel() {
        FlowPanel panel = new FlowPanel();
        panel.addStyleName(DEFAULT_PANEL_STYLE);
        FlowPanel colsLabel = new FlowPanel();
        colsLabel.setStyleName(INFO_LABEL_STYLE);
        colsLabel.add((Widget)new InlineLabel(Strings.INSTANCE.tableColsLabel()));
        InlineLabel mandatoryLabel = new InlineLabel(Strings.INSTANCE.mandatory());
        mandatoryLabel.addStyleName(MANDATORY_STYLE);
        colsLabel.add((Widget)mandatoryLabel);
        panel.add((Widget)colsLabel);
        Label colsHelpLabel = new Label(Strings.INSTANCE.tableColsHelpLabel());
        colsHelpLabel.setStyleName(HELP_LABEL_STYLE);
        panel.add((Widget)colsHelpLabel);
        this.columnsValidationMessage = new Label(Strings.INSTANCE.tableInsertStrictPositiveIntegerRequired());
        this.columnsValidationMessage.setVisible(false);
        this.columnsValidationMessage.addStyleName(ERROR_STYLE);
        panel.add((Widget)this.columnsValidationMessage);
        this.columns = new TextBox();
        this.columns.setText(String.valueOf(this.descriptor.getColumnCount()));
        this.columns.setTitle(Strings.INSTANCE.tableColsToolTip());
        this.columns.addKeyPressHandler((KeyPressHandler)new TextBoxNumberFilter());
        this.columns.addKeyUpHandler((KeyUpHandler)this);
        panel.add((Widget)this.columns);
        return panel;
    }

    private Panel getBorderPanel() {
        FlowPanel panel = new FlowPanel();
        panel.addStyleName(DEFAULT_PANEL_STYLE);
        Label borderSizeLabel = new Label(Strings.INSTANCE.tableBorderLabel());
        borderSizeLabel.setStyleName(INFO_LABEL_STYLE);
        panel.add((Widget)borderSizeLabel);
        Label borderSizeHelpLabel = new Label(Strings.INSTANCE.tableBorderHelpLabel());
        borderSizeHelpLabel.setStyleName(HELP_LABEL_STYLE);
        panel.add((Widget)borderSizeHelpLabel);
        this.border = new TextBox();
        this.border.addStyleName("xBorderInput");
        this.border.addKeyPressHandler((KeyPressHandler)new TextBoxNumberFilter());
        this.border.addKeyUpHandler((KeyUpHandler)this);
        panel.add((Widget)this.border);
        Label borderPixelLabel = new Label(Strings.INSTANCE.tablePixel());
        borderPixelLabel.setStyleName("xTablePixel");
        panel.add((Widget)borderPixelLabel);
        return panel;
    }

    private Panel getHeaderPanel() {
        FlowPanel panel = new FlowPanel();
        panel.addStyleName(DEFAULT_PANEL_STYLE);
        this.header = new CheckBox(Strings.INSTANCE.tableHeaderLabel());
        this.header.addStyleName(INFO_LABEL_STYLE);
        this.header.addKeyUpHandler((KeyUpHandler)this);
        this.header.setValue(Boolean.valueOf(this.descriptor.isWithHeader()));
        panel.add((Widget)this.header);
        Label headerHelpLabel = new Label(Strings.INSTANCE.tableHeaderHelpLabel());
        headerHelpLabel.setStyleName(HELP_LABEL_STYLE);
        panel.add((Widget)headerHelpLabel);
        return panel;
    }

    private boolean validate() {
        this.hideValidationMessages();
        TextBox failed = null;
        if (!this.validateRequiredStrictPositiveIntger(this.columns.getText())) {
            this.columnsValidationMessage.setVisible(true);
            this.columns.addStyleName(FIELD_ERROR_STYLE);
            failed = this.columns;
        }
        if (!this.validateRequiredStrictPositiveIntger(this.rows.getText())) {
            this.rowsValidationMessage.setVisible(true);
            this.rows.addStyleName(FIELD_ERROR_STYLE);
            failed = this.rows;
        }
        if (failed != null) {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new FocusCommand((Focusable)failed));
            return false;
        }
        return true;
    }

    private boolean validateRequiredStrictPositiveIntger(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        try {
            int rowCount = Integer.parseInt(str);
            if (rowCount <= 0) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private void hideValidationMessages() {
        this.rowsValidationMessage.setVisible(false);
        this.rows.removeStyleName(FIELD_ERROR_STYLE);
        this.columnsValidationMessage.setVisible(false);
        this.columns.removeStyleName(FIELD_ERROR_STYLE);
    }

    private void updateTableDescriptor() {
        this.descriptor.setRowCount(Integer.parseInt(this.rows.getText()));
        this.descriptor.setColumnCount(Integer.parseInt(this.columns.getText()));
        this.descriptor.setWithHeader(this.header.getValue());
    }
}

