/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.user.client.Timer;
import org.xwiki.gwt.user.client.TimerListener;
import org.xwiki.gwt.wysiwyg.client.WysiwygEditor;
import org.xwiki.gwt.wysiwyg.client.cleaner.HTMLCleaner;
import org.xwiki.gwt.wysiwyg.client.cleaner.HTMLCleanerAsync;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverter;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverterAsync;

public class WysiwygEditorDebugger
extends Composite
implements TimerListener {
    private WysiwygEditor editor;
    private TextArea wikiTextArea;
    private TextArea dirtyHTMLTextArea;
    private TextArea cleanHTMLTextArea;
    private TextArea eventsTextArea;
    private Timer timer;
    private String previousHTML = "";
    private final HTMLCleanerAsync cleaner = (HTMLCleanerAsync)GWT.create(HTMLCleaner.class);
    private final HTMLConverterAsync converter = (HTMLConverterAsync)GWT.create(HTMLConverter.class);

    public WysiwygEditorDebugger(WysiwygEditor editor) {
        this.editor = editor;
        FlowPanel panel = new FlowPanel();
        panel.setWidth("100%");
        panel.add(editor.getUI());
        String width = "400px";
        String height = "220px";
        this.dirtyHTMLTextArea = new TextArea();
        this.dirtyHTMLTextArea.setWidth(width);
        this.dirtyHTMLTextArea.setHeight(height);
        panel.add((Widget)this.dirtyHTMLTextArea);
        this.cleanHTMLTextArea = new TextArea();
        this.cleanHTMLTextArea.setWidth(width);
        this.cleanHTMLTextArea.setHeight(height);
        panel.add((Widget)this.cleanHTMLTextArea);
        this.wikiTextArea = new TextArea();
        this.wikiTextArea.setWidth(width);
        this.wikiTextArea.setHeight(height);
        panel.add((Widget)this.wikiTextArea);
        this.eventsTextArea = new TextArea();
        this.eventsTextArea.setWidth(width);
        this.eventsTextArea.setHeight(height);
        panel.add((Widget)this.eventsTextArea);
        this.dirtyHTMLTextArea.setText(editor.getRichTextEditor().getTextArea().getHTML());
        this.initWidget((Widget)panel);
        this.timer = new Timer();
        this.timer.addTimerListener((TimerListener)this);
        this.timer.scheduleRepeating(4000);
    }

    public void refreshData() {
        String currentHTML = this.editor.getRichTextEditor().getTextArea().getHTML();
        if (this.previousHTML.equals(currentHTML)) {
            return;
        }
        this.previousHTML = currentHTML;
        this.dirtyHTMLTextArea.setText(currentHTML);
        this.cleaner.clean(currentHTML, new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                WysiwygEditorDebugger.this.cleanHTMLTextArea.setText(caught.toString());
            }

            public void onSuccess(String result) {
                WysiwygEditorDebugger.this.cleanHTMLTextArea.setText(result);
            }
        });
        this.converter.fromHTML(currentHTML, this.editor.getConfig().getSyntax(), new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                WysiwygEditorDebugger.this.wikiTextArea.setText(caught.toString());
            }

            public void onSuccess(String result) {
                WysiwygEditorDebugger.this.wikiTextArea.setText(result);
            }
        });
        this.converter.fromHTML(currentHTML, "event/1.0", new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                WysiwygEditorDebugger.this.eventsTextArea.setText(caught.toString());
            }

            public void onSuccess(String result) {
                WysiwygEditorDebugger.this.eventsTextArea.setText(result);
            }
        });
    }

    public void onElapsed(Timer sender) {
        if (sender == this.timer) {
            this.refreshData();
        }
    }
}

