/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.color;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.wysiwyg.client.plugin.color.ColorCell;
import org.xwiki.gwt.wysiwyg.client.plugin.color.ColorConverter;

public class ColorPalette
extends Composite
implements HasSelectionHandlers<String>,
ClickHandler {
    private ColorCell selectedCell;
    private final ColorConverter converter = new ColorConverter();

    public ColorPalette(String[] colors, int columnCount) {
        Grid colorGrid = new Grid(1 + (colors.length - 1) / columnCount, Math.min(columnCount, colors.length));
        colorGrid.addStyleName("xColorPalette");
        colorGrid.setBorderWidth(0);
        colorGrid.setCellPadding(0);
        colorGrid.setCellSpacing(0);
        colorGrid.addClickHandler((ClickHandler)this);
        for (int i = 0; i < colors.length; ++i) {
            colorGrid.setWidget(i / columnCount, i % columnCount, (Widget)new ColorCell(colors[i]));
        }
        this.initWidget((Widget)colorGrid);
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<String> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    protected Grid getColorGrid() {
        return (Grid)this.getWidget();
    }

    public void onClick(ClickEvent event) {
        HTMLTable.Cell cell;
        if (event.getSource() == this.getColorGrid() && (cell = this.getColorGrid().getCellForEvent(event)) != null) {
            this.setSelectedCell((ColorCell)this.getColorGrid().getWidget(cell.getRowIndex(), cell.getCellIndex()));
            SelectionEvent.fire((HasSelectionHandlers)this, (Object)this.getSelectedColor());
        }
    }

    private void setSelectedCell(ColorCell cell) {
        if (this.selectedCell != cell) {
            if (this.selectedCell != null) {
                this.selectedCell.setSelected(false);
            }
            this.selectedCell = cell;
            if (this.selectedCell != null) {
                this.selectedCell.setSelected(true);
            }
        }
    }

    public String getSelectedColor() {
        return this.selectedCell != null ? this.selectedCell.getColor() : null;
    }

    public void setSelectedColor(String color) {
        if (color != null) {
            String hexColorCode = this.converter.convertToHex(color);
            for (int i = 0; i < this.getColorGrid().getRowCount(); ++i) {
                for (int j = 0; j < this.getColorGrid().getColumnCount(); ++j) {
                    ColorCell cell = (ColorCell)this.getColorGrid().getWidget(i, j);
                    if (!color.equalsIgnoreCase(cell.getColor()) && (hexColorCode == null || !hexColorCode.equalsIgnoreCase(cell.getHexColorCode()))) continue;
                    this.setSelectedCell(cell);
                    return;
                }
            }
        }
        this.setSelectedCell(null);
    }
}

