/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.format.exec;

import com.google.gwt.dom.client.Node;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Text;
import org.xwiki.gwt.dom.client.TextFragment;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.ToggleInlineStyleExecutable;

public class RemoveFormatExecutable
extends ToggleInlineStyleExecutable {
    public static final String CSS_TEXT = "cssText";
    public static final List<String> DO_NOT_SPLIT = Arrays.asList("a");

    public RemoveFormatExecutable(RichTextArea rta) {
        super(rta, null, null, null);
    }

    protected TextFragment removeStyle(Text text, int firstCharIndex, int lastCharIndex) {
        text.crop(firstCharIndex, lastCharIndex);
        Stack<Node> stack = this.getInlineAncestorsStack((Node)text);
        Node top = null;
        while (stack.size() > 1) {
            Node parent = stack.pop();
            if (DO_NOT_SPLIT.contains(parent.getNodeName().toLowerCase())) {
                if (this.splitParenStyle(stack.peek())) {
                    stack.push(stack.peek().getParentNode());
                }
                if (top == null) continue;
                this.reorder(top, stack.peek());
                continue;
            }
            if (top == null) {
                this.domUtils.isolate(stack.peek());
                top = parent;
                continue;
            }
            this.isolateUpTo(stack.peek(), top);
        }
        if (top != null) {
            top.getParentNode().replaceChild((Node)text, top);
        }
        return new TextFragment(text, 0, text.getLength());
    }

    protected Stack<Node> getInlineAncestorsStack(Node node) {
        Stack<Node> stack = new Stack<Node>();
        for (Node ancestor = node; ancestor != null && this.domUtils.isInline(ancestor); ancestor = ancestor.getParentNode()) {
            stack.push(ancestor);
        }
        return stack;
    }

    protected boolean splitParenStyle(Node child) {
        Element parent = (Element)child.getParentNode();
        if (parent == null || StringUtils.isEmpty((String)parent.getStyle().getProperty(CSS_TEXT))) {
            return false;
        }
        if (child.getPreviousSibling() != null) {
            Element left = (Element)child.getOwnerDocument().createSpanElement().cast();
            left.appendChild(child.getPreviousSibling());
            while (child.getPreviousSibling() != null) {
                left.insertBefore(child.getPreviousSibling(), left.getFirstChild());
            }
            left.getStyle().setProperty(CSS_TEXT, parent.getStyle().getProperty(CSS_TEXT));
            parent.insertBefore((Node)left, child);
        }
        if (child.getNextSibling() != null) {
            Element right = (Element)child.getOwnerDocument().createSpanElement().cast();
            do {
                right.appendChild(child.getNextSibling());
            } while (child.getNextSibling() != null);
            right.getStyle().setProperty(CSS_TEXT, parent.getStyle().getProperty(CSS_TEXT));
            parent.appendChild((Node)right);
        }
        Element wrapper = (Element)child.getOwnerDocument().createSpanElement().cast();
        wrapper.getStyle().setProperty(CSS_TEXT, parent.getStyle().getProperty(CSS_TEXT));
        parent.replaceChild((Node)wrapper, child);
        wrapper.appendChild(child);
        parent.removeAttribute("style");
        return true;
    }

    protected void reorder(Node top, Node child) {
        Node leaf;
        Node parent = child.getParentNode();
        if (parent == null || parent == top) {
            return;
        }
        Node grandParent = parent.getParentNode();
        if (grandParent == null) {
            return;
        }
        int index = this.domUtils.getNodeIndex(parent);
        grandParent.removeChild(parent);
        if (child.getPreviousSibling() != null) {
            Node left = top.cloneNode(true);
            leaf = this.domUtils.getLastLeaf(left);
            leaf.appendChild(child.getPreviousSibling());
            while (child.getPreviousSibling() != null) {
                leaf.insertBefore(child.getPreviousSibling(), leaf.getFirstChild());
            }
            parent.insertBefore(left, child);
        }
        if (child.getNextSibling() != null) {
            Node right = top.cloneNode(true);
            leaf = this.domUtils.getFirstLeaf(right);
            do {
                leaf.appendChild(child.getNextSibling());
            } while (child.getNextSibling() != null);
            parent.appendChild(right);
        }
        top.getParentNode().replaceChild(parent, top);
        parent.replaceChild(top, child);
        this.domUtils.insertAt(grandParent, child, index);
    }

    protected void isolateUpTo(Node child, Node top) {
        Node ancestor = child;
        do {
            this.domUtils.isolate(ancestor);
        } while ((ancestor = ancestor.getParentNode()) != null && ancestor != top);
    }

    public boolean isExecuted() {
        return true;
    }

    public String getParameter() {
        return null;
    }
}

