/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.user.client.EscapeUtils;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.AbstractInsertElementExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigDOMReader;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;

public class LinkConfigDOMReader
implements AbstractInsertElementExecutable.ConfigDOMReader<LinkConfig, AnchorElement> {
    private static final String LINK_REFERENCE_COMPONENT_SEPARATOR = "|-|";
    private final ImageConfigDOMReader imageConfigHTMLParser = new ImageConfigDOMReader();

    public LinkConfig read(AnchorElement anchor) {
        LinkConfig linkConfig = new LinkConfig();
        DocumentFragment linkMetadata = Element.as((Node)anchor).getMetaData();
        if (linkMetadata != null) {
            String startComment = linkMetadata.getChildNodes().getItem(0).getNodeValue();
            Element wrappingSpan = (Element)linkMetadata.getChildNodes().getItem(1);
            linkConfig.setReference(EscapeUtils.unescapeBackslash((String)startComment.substring("startwikilink:".length())));
            linkConfig.setType(this.readLinkType(wrappingSpan, linkConfig.getReference()));
        } else {
            linkConfig.setType(LinkConfig.LinkType.EXTERNAL);
        }
        linkConfig.setUrl(anchor.getAttribute("href"));
        linkConfig.setLabel(anchor.getInnerHTML());
        if (anchor.getChildNodes().getLength() == 1 && "img".equalsIgnoreCase(anchor.getFirstChild().getNodeName())) {
            ImageElement image = (ImageElement)anchor.getFirstChild();
            linkConfig.setLabelText(this.imageConfigHTMLParser.read(image).getReference());
            linkConfig.setReadOnlyLabel(true);
        } else {
            linkConfig.setLabelText(anchor.getInnerText());
        }
        linkConfig.setTooltip(anchor.getTitle());
        linkConfig.setOpenInNewWindow("__blank".equals(anchor.getRel()));
        return linkConfig;
    }

    private LinkConfig.LinkType readLinkType(Element wrappingSpan, String reference) {
        LinkConfig.LinkType linkType = LinkConfig.LinkType.getByClassName(wrappingSpan.getClassName());
        if (linkType == null) {
            linkType = LinkConfig.LinkType.EXTERNAL;
        } else if (linkType == LinkConfig.LinkType.EXTERNAL && "mailto".equalsIgnoreCase(this.getLinkProtocol(reference))) {
            linkType = LinkConfig.LinkType.EMAIL;
        }
        return linkType;
    }

    private String getLinkProtocol(String linkReference) {
        int beginIndex = linkReference.indexOf(LINK_REFERENCE_COMPONENT_SEPARATOR);
        if (beginIndex < 0) {
            return null;
        }
        int endIndex = linkReference.indexOf(LINK_REFERENCE_COMPONENT_SEPARATOR, beginIndex += LINK_REFERENCE_COMPONENT_SEPARATOR.length());
        if (endIndex < 0) {
            return null;
        }
        return linkReference.substring(beginIndex, endIndex);
    }
}

