/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.style.exec;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.dom.client.Text;
import org.xwiki.gwt.dom.client.TextFragment;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.InlineStyleExecutable;

public class InlineStyleNameExecutable
extends InlineStyleExecutable {
    private boolean executed;

    public InlineStyleNameExecutable(RichTextArea rta) {
        super(rta, null);
    }

    public boolean execute(String parameter) {
        this.executed = this.getStyleNames(this.rta.getDocument().getSelection()).contains(parameter);
        return super.execute(parameter);
    }

    protected TextFragment execute(Text text, int startIndex, int endIndex, String parameter) {
        if (this.executed) {
            return this.removeStyleName(text, startIndex, endIndex, parameter);
        }
        if (!this.matchesStyleName(text, parameter)) {
            return super.execute(text, startIndex, endIndex, parameter);
        }
        return new TextFragment(text, startIndex, endIndex);
    }

    protected void addStyle(org.xwiki.gwt.dom.client.Element element, String parameter) {
        element.addClassName(parameter);
    }

    protected boolean matchesStyleName(Text text, String parameter) {
        for (Node ancestor = text.getParentNode(); ancestor != null && ancestor.getNodeType() == 1 && this.domUtils.isInline(ancestor); ancestor = ancestor.getParentNode()) {
            if (!org.xwiki.gwt.dom.client.Element.as((Node)ancestor).hasClassName(parameter)) continue;
            return true;
        }
        return false;
    }

    protected TextFragment removeStyleName(Text text, int startIndex, int endIndex, String styleName) {
        text.crop(startIndex, endIndex);
        Text child = text;
        Node parent = child.getParentNode();
        while (parent != null && parent.getNodeType() == 1 && this.domUtils.isInline(parent)) {
            this.domUtils.isolate((Node)child);
            org.xwiki.gwt.dom.client.Element.as((Node)parent).removeClassName(styleName);
            child = child.getParentNode();
            parent = child.getParentNode();
        }
        return new TextFragment(text, 0, text.getLength());
    }

    public String getParameter() {
        return StringUtils.join(this.getStyleNames(this.rta.getDocument().getSelection()), (String)" ");
    }

    protected Set<String> getStyleNames(Selection selection) {
        Set<String> selectionStyleNames = null;
        for (int i = 0; i < selection.getRangeCount(); ++i) {
            Set<String> rangeStyleNames = this.getStyleNames(selection.getRangeAt(i));
            if (selectionStyleNames == null) {
                selectionStyleNames = rangeStyleNames;
            } else {
                selectionStyleNames.retainAll(rangeStyleNames);
            }
            if (selectionStyleNames.isEmpty()) break;
        }
        if (selectionStyleNames == null) {
            selectionStyleNames = Collections.emptySet();
        }
        return selectionStyleNames;
    }

    protected Set<String> getStyleNames(Range range) {
        if (range.isCollapsed()) {
            return this.getStyleNames(range.getStartContainer());
        }
        List textNodes = this.getNonEmptyTextNodes(range);
        Set<String> rangeStyleNames = null;
        for (int i = 0; i < textNodes.size(); ++i) {
            Set<String> textStyleNames = this.getStyleNames((Node)textNodes.get(i));
            if (rangeStyleNames == null) {
                rangeStyleNames = textStyleNames;
            } else {
                rangeStyleNames.retainAll(textStyleNames);
            }
            if (rangeStyleNames.isEmpty()) break;
        }
        if (rangeStyleNames == null) {
            rangeStyleNames = Collections.emptySet();
        }
        return rangeStyleNames;
    }

    protected Set<String> getStyleNames(Node node) {
        HashSet<String> styleNames = new HashSet<String>();
        for (Element ancestor = node.getParentElement(); ancestor != null && ancestor.getNodeType() == 1 && this.domUtils.isInline((Node)ancestor); ancestor = ancestor.getParentNode()) {
            String className = org.xwiki.gwt.dom.client.Element.as((Node)ancestor).getClassName();
            if (StringUtils.isEmpty((String)className)) continue;
            styleNames.addAll(Arrays.asList(className.split("\\s+")));
        }
        return styleNames;
    }

    public boolean isExecuted() {
        return true;
    }
}

