/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xwiki.gwt.wysiwyg.client.MenuItemDescriptor;

public class MenuItemDescriptorJSONParser {
    public List<MenuItemDescriptor> parse(String json) {
        return this.getMenuItemDescriptors(JSONParser.parseStrict((String)json));
    }

    private List<MenuItemDescriptor> getMenuItemDescriptors(JSONValue value) {
        JSONArray jsDescriptors = value.isArray();
        if (jsDescriptors == null) {
            return Collections.emptyList();
        }
        ArrayList<MenuItemDescriptor> descriptors = new ArrayList<MenuItemDescriptor>();
        for (int i = 0; i < jsDescriptors.size(); ++i) {
            MenuItemDescriptor descriptor = this.getMenuItemDescriptor(jsDescriptors.get(i));
            if (descriptor == null) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    private MenuItemDescriptor getMenuItemDescriptor(JSONValue value) {
        JSONString feature = value.isString();
        if (feature != null) {
            return new MenuItemDescriptor(feature.stringValue());
        }
        JSONObject jsDescriptor = value.isObject();
        if (jsDescriptor == null) {
            return null;
        }
        JSONValue oFeature = jsDescriptor.get("feature");
        if (oFeature == null || oFeature.isString() == null) {
            return null;
        }
        MenuItemDescriptor descriptor = new MenuItemDescriptor(oFeature.isString().stringValue());
        JSONValue subMenu = jsDescriptor.get("subMenu");
        if (subMenu != null) {
            descriptor.getSubMenu().addAll(this.getMenuItemDescriptors(subMenu));
        }
        return descriptor;
    }
}

