/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.exec;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import java.util.Arrays;
import java.util.Map;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.URLUtils;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.AbstractInsertElementExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigDOMReader;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigDOMWriter;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigJSONParser;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigJSONSerializer;

public class InsertImageExecutable
extends AbstractInsertElementExecutable<ImageConfig, ImageElement> {
    public InsertImageExecutable(RichTextArea rta) {
        super(rta);
        this.configDOMReader = new ImageConfigDOMReader();
        this.configDOMWriter = (AbstractInsertElementExecutable.ConfigDOMWriter)GWT.create(ImageConfigDOMWriter.class);
        this.configJSONParser = new ImageConfigJSONParser();
        this.configJSONSerializer = new ImageConfigJSONSerializer();
    }

    protected void write(ImageConfig config, ImageElement image) {
        boolean internal;
        String url = config.getUrl();
        boolean bl = internal = !StringUtils.areEqual((String)config.getReference(), (String)url);
        if (internal) {
            config.setUrl(image.getSrc());
        }
        super.write((Object)config, (Element)image);
        if (internal) {
            this.updateURL(image, url);
        }
    }

    protected String getCacheKeyPrefix() {
        return InsertImageExecutable.class.getName();
    }

    protected ImageElement getSelectedElement() {
        Node nodeInside;
        Node endContainer;
        Range currentRange = this.rta.getDocument().getSelection().getRangeAt(0);
        Node startContainer = currentRange.getStartContainer();
        if (startContainer == (endContainer = currentRange.getEndContainer()) && startContainer.getNodeType() == 1 && currentRange.getEndOffset() - currentRange.getStartOffset() == 1 && (nodeInside = startContainer.getChildNodes().getItem(currentRange.getStartOffset())).getNodeType() == 1 && nodeInside.getNodeName().equalsIgnoreCase("img")) {
            return (ImageElement)nodeInside;
        }
        return null;
    }

    protected ImageElement newElement() {
        ImageElement image = this.rta.getDocument().createImageElement();
        image.setSrc(GWT.getModuleBaseURL() + "clear.cache.gif");
        return image;
    }

    private void updateURL(ImageElement image, String url) {
        int width = image.getWidth();
        int height = image.getHeight();
        Map parameters = URLUtils.parseQueryString((String)URLUtils.getQueryString((String)url));
        parameters.remove("width");
        parameters.remove("height");
        parameters.remove("keepAspectRatio");
        if (this.isDimensionSpecified(image, "width")) {
            parameters.put("width", Arrays.asList(String.valueOf(width)));
            if (this.isDimensionSpecified(image, "height")) {
                parameters.put("height", Arrays.asList(String.valueOf(height)));
            }
        } else if (this.isDimensionSpecified(image, "height")) {
            parameters.put("height", Arrays.asList(String.valueOf(height)));
        } else {
            int widthLimit = image.getOwnerDocument().getClientWidth() - 22;
            if (widthLimit > 0) {
                parameters.put("width", Arrays.asList(String.valueOf(widthLimit)));
            }
        }
        image.setSrc(URLUtils.setQueryString((String)url, (Map)parameters));
    }

    private boolean isDimensionSpecified(ImageElement image, String dimension) {
        return image.getPropertyInt(dimension) > 0 && (!StringUtils.isEmpty((String)image.getStyle().getProperty(dimension)) || image.hasAttribute(dimension));
    }
}

