/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.InnerHTMLListener;
import org.xwiki.gwt.dom.client.Text;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;

public class LinkMetaDataExtractor
implements InnerHTMLListener {
    public void onInnerHTMLChange(Element parent) {
        NodeList anchors = parent.getElementsByTagName("a");
        for (int i = 0; i < anchors.getLength(); ++i) {
            Element anchor = (Element)anchors.getItem(i);
            this.processElement(anchor);
        }
    }

    private void processElement(Element anchor) {
        Element parentNode = (Element)anchor.getParentElement().cast();
        if (parentNode == null || !"span".equalsIgnoreCase(parentNode.getNodeName()) || LinkConfig.LinkType.getByClassName(parentNode.getClassName()) == null || !this.hasLinkMarkers((Node)parentNode)) {
            return;
        }
        DocumentFragment metaFragment = ((Document)anchor.getOwnerDocument()).createDocumentFragment();
        metaFragment.appendChild(parentNode.getPreviousSibling());
        metaFragment.appendChild(parentNode.getNextSibling());
        Text placeholder = (Text)((Document)anchor.getOwnerDocument()).createTextNode("org.xwiki.gwt.dom.client.Element#placeholder");
        parentNode.replaceChild((Node)placeholder, (Node)anchor);
        parentNode.getParentElement().replaceChild((Node)anchor, (Node)parentNode);
        metaFragment.insertAfter((Node)parentNode, metaFragment.getFirstChild());
        anchor.setMetaData(metaFragment);
    }

    private boolean hasLinkMarkers(Node node) {
        return this.hasLinkStartMarker(node) && this.hasLinkStopMarker(node);
    }

    private boolean hasLinkStartMarker(Node node) {
        Node previousSibling = node.getPreviousSibling();
        return previousSibling != null && previousSibling.getNodeType() == 8 && previousSibling.getNodeValue().startsWith("startwikilink");
    }

    private boolean hasLinkStopMarker(Node node) {
        Node nextSibling = node.getNextSibling();
        return nextSibling != null && nextSibling.getNodeType() == 8 && nextSibling.getNodeValue().startsWith("stopwikilink");
    }
}

