/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.indent.exec;

import com.google.gwt.dom.client.Node;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.wysiwyg.client.plugin.indent.exec.AbstractListExecutable;

public class IndentExecutable
extends AbstractListExecutable {
    public IndentExecutable(RichTextArea rta) {
        super(rta);
    }

    @Override
    protected boolean executeOnMultipleItems(Range range, boolean perform) {
        boolean indentResult = false;
        Node rangeLeaf = this.domUtils.getFirstLeaf(range);
        Node lastLeaf = this.domUtils.getLastLeaf(range);
        Element lastProcessed = null;
        while (rangeLeaf != null) {
            Element currentLi = (Element)this.domUtils.getFirstAncestor(rangeLeaf, new String[]{"li"});
            if (lastProcessed == null || currentLi != null && !lastProcessed.isOrHasChild((Node)currentLi)) {
                if (lastProcessed == null || currentLi != null && lastProcessed != currentLi.getPreviousSibling()) {
                    indentResult = this.checkAndPerformIndent(currentLi, perform) || indentResult;
                }
                lastProcessed = currentLi;
            }
            rangeLeaf = this.getNextLeafBefore(rangeLeaf, lastLeaf);
        }
        return indentResult;
    }

    private boolean checkAndPerformIndent(Element item, boolean perform) {
        boolean canIndent = this.canExecute(item);
        if (perform && canIndent) {
            this.execute(item);
        }
        return canIndent;
    }

    private Node getNextLeafBefore(Node currentLeaf, Node lastLeaf) {
        if (currentLeaf == lastLeaf) {
            return null;
        }
        return this.domUtils.getNextLeaf(currentLeaf);
    }

    @Override
    protected boolean canExecute(Element listItem) {
        if (!super.canExecute(listItem)) {
            return false;
        }
        Node previousListItem = listItem.getPreviousSibling();
        return previousListItem != null && previousListItem.getNodeName().equalsIgnoreCase("li");
    }

    @Override
    protected void execute(Element listItem) {
        Node previousListItem = listItem.getPreviousSibling();
        Node lastChild = previousListItem.getLastChild();
        Element lastSecondLevelList = null;
        if (this.isList(lastChild)) {
            lastSecondLevelList = (Element)lastChild;
        }
        if (lastSecondLevelList == null) {
            lastSecondLevelList = (Element)listItem.getOwnerDocument().createElement(listItem.getParentNode().getNodeName());
            previousListItem.appendChild((Node)lastSecondLevelList);
        }
        lastSecondLevelList.appendChild((Node)listItem);
    }
}

