/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.table.ui;

import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.ui.UIObject;
import java.util.Arrays;
import java.util.List;
import org.xwiki.gwt.user.client.RichTextAreaCommand;
import org.xwiki.gwt.user.client.ui.MenuItem;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.MenuItemUIExtensionAdaptor;
import org.xwiki.gwt.wysiwyg.client.plugin.table.TableFeature;
import org.xwiki.gwt.wysiwyg.client.plugin.table.TablePlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.table.TablePluginFactory;

public class TableMenuExtension
extends MenuItemUIExtensionAdaptor {
    private final TablePlugin plugin;
    private final MenuItem insertTable;
    private final List<MenuItem> editItems;

    public TableMenuExtension(TablePlugin plugin) {
        super("menu");
        this.plugin = plugin;
        this.insertTable = this.createMenuItem(Strings.INSTANCE.insertTable(), null, (com.google.gwt.user.client.Command)new RichTextAreaCommand(plugin.getTextArea(), new Command("inserttable"), null, false));
        MenuItem deleteCol = this.createMenuItem(Strings.INSTANCE.deleteCol(), Images.INSTANCE.deleteCol(), (com.google.gwt.user.client.Command)new RichTextAreaCommand(plugin.getTextArea(), new Command("deletecol")));
        MenuItem deleteRow = this.createMenuItem(Strings.INSTANCE.deleteRow(), Images.INSTANCE.deleteRow(), (com.google.gwt.user.client.Command)new RichTextAreaCommand(plugin.getTextArea(), new Command("deleterow")));
        MenuItem deleteTable = this.createMenuItem(Strings.INSTANCE.deleteTable(), Images.INSTANCE.deleteTable(), (com.google.gwt.user.client.Command)new RichTextAreaCommand(plugin.getTextArea(), new Command("deletetable")));
        MenuItem insertColAfter = this.createMenuItem(Strings.INSTANCE.insertColAfter(), Images.INSTANCE.insertColAfter(), (com.google.gwt.user.client.Command)new RichTextAreaCommand(plugin.getTextArea(), new Command("insertcolafter")));
        MenuItem insertColBefore = this.createMenuItem(Strings.INSTANCE.insertColBefore(), Images.INSTANCE.insertColBefore(), (com.google.gwt.user.client.Command)new RichTextAreaCommand(plugin.getTextArea(), new Command("insertcolbefore")));
        MenuItem insertRowAfter = this.createMenuItem(Strings.INSTANCE.insertRowAfter(), Images.INSTANCE.insertRowAfter(), (com.google.gwt.user.client.Command)new RichTextAreaCommand(plugin.getTextArea(), new Command("insertrowafter")));
        MenuItem insertRowBefore = this.createMenuItem(Strings.INSTANCE.insertRowBefore(), Images.INSTANCE.insertRowBefore(), (com.google.gwt.user.client.Command)new RichTextAreaCommand(plugin.getTextArea(), new Command("insertrowbefore")));
        MenuItem tableMenu = this.createMenuItem(Strings.INSTANCE.table(), Images.INSTANCE.insertTable());
        this.editItems = Arrays.asList(deleteCol, deleteRow, deleteTable, insertColAfter, insertColBefore, insertRowAfter, insertRowBefore);
        this.addFeature(TablePluginFactory.getInstance().getPluginName(), (UIObject)tableMenu);
        this.addFeature("inserttable", (UIObject)this.insertTable);
        this.addFeature("deletecol", (UIObject)deleteCol);
        this.addFeature("deleterow", (UIObject)deleteRow);
        this.addFeature("deletetable", (UIObject)deleteTable);
        this.addFeature("insertcolafter", (UIObject)insertColAfter);
        this.addFeature("insertcolbefore", (UIObject)insertColBefore);
        this.addFeature("insertrowafter", (UIObject)insertRowAfter);
        this.addFeature("insertrowbefore", (UIObject)insertRowBefore);
    }

    protected void onAttach(AttachEvent event) {
        boolean editMode = this.plugin.getTextArea().getCommandManager().isEnabled(new Command("deletetable"));
        List<TableFeature> features = this.plugin.getFeatures();
        for (TableFeature feature : features) {
            MenuItem item = (MenuItem)this.getUIObject(feature.getName());
            if (item.getParentMenu() != event.getSource() || !this.editItems.contains(item)) continue;
            item.setEnabled(editMode && feature.isEnabled());
            item.setVisible(editMode);
        }
        if (this.insertTable.getParentMenu() == event.getSource()) {
            this.insertTable.setEnabled(!editMode && this.plugin.getTextArea().getCommandManager().isEnabled(new Command("inserttable")));
            this.insertTable.setVisible(!editMode);
        }
    }
}

