/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.wiki;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;

public class ResourceReference
implements IsSerializable {
    private ResourceType type;
    private boolean typed = true;
    private EntityReference entityReference = new EntityReference();
    private Map<String, String> parameters = new HashMap<String, String>();

    public ResourceType getType() {
        return this.type;
    }

    public void setType(ResourceType type) {
        this.type = type;
    }

    public boolean isTyped() {
        return this.typed;
    }

    public void setTyped(boolean typed) {
        this.typed = typed;
    }

    public EntityReference getEntityReference() {
        return this.entityReference;
    }

    public void setEntityReference(EntityReference entityReference) {
        this.entityReference = entityReference;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public ResourceReference clone() {
        ResourceReference resourceReference = new ResourceReference();
        resourceReference.setType(this.type);
        resourceReference.setTyped(this.typed);
        if (this.entityReference != null) {
            resourceReference.setEntityReference(this.entityReference.clone());
        }
        resourceReference.getParameters().putAll(this.parameters);
        return resourceReference;
    }

    public static enum ResourceType {
        DOCUMENT("doc"),
        URL("url"),
        INTERWIKI("interwiki"),
        PATH("path"),
        MAILTO("mailto"),
        ATTACHMENT("attach");

        private static final Map<String, ResourceType> SCHEME_TO_RESOURCE_TYPE;
        private final String scheme;

        private ResourceType(String scheme) {
            this.scheme = scheme;
        }

        public String getScheme() {
            return this.scheme;
        }

        public static ResourceType forScheme(String scheme) {
            return SCHEME_TO_RESOURCE_TYPE.get(scheme);
        }

        static {
            SCHEME_TO_RESOURCE_TYPE = new HashMap<String, ResourceType>();
            for (ResourceType type : ResourceType.values()) {
                SCHEME_TO_RESOURCE_TYPE.put(type.getScheme(), type);
            }
        }
    }
}

