/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.user.client.BackForwardCache;
import org.xwiki.gwt.user.client.Config;

public class WysiwygEditorConfig
implements Window.ClosingHandler {
    public static final String DEFAULT_SYNTAX = "xhtml/1.0";
    public static final int WYSIWYG_TAB_INDEX = 0;
    public static final int SOURCE_TAB_INDEX = 1;
    private static final String CACHE_KEY_ACTIVE_TEXT_AREA = "editor.activeTextArea";
    private static final String CACHE_KEY_INPUT_CONVERTED = "editor.inputConverted";
    private final Config config;
    private final BackForwardCache cache;

    public WysiwygEditorConfig(Config config) {
        this.config = config;
        this.cache = new BackForwardCache(Element.as((Node)DOM.getElementById((String)config.getParameter("cacheId", ""))));
        Window.addWindowClosingHandler((Window.ClosingHandler)this);
    }

    public String getSyntax() {
        return this.config.getParameter("syntax", DEFAULT_SYNTAX);
    }

    public boolean isInputConverted() {
        boolean inputConverted = Boolean.valueOf(this.config.getParameter("convertInput", String.valueOf(false))) == false;
        return Boolean.valueOf(this.cache.get(CACHE_KEY_INPUT_CONVERTED, String.valueOf(inputConverted)));
    }

    public void setInputConverted(boolean inputConverted) {
        this.cache.put(CACHE_KEY_INPUT_CONVERTED, String.valueOf(inputConverted));
    }

    public Element getHook() {
        return Element.as((Node)DOM.getElementById((String)this.config.getParameter("hookId")));
    }

    public String getInputValue() {
        return this.getHook().getPropertyString("value");
    }

    public boolean isTabbed() {
        return Boolean.valueOf(this.config.getParameter("displayTabs", String.valueOf(false)));
    }

    public int getSelectedTabIndex() {
        String defaultEditor = this.config.getParameter("defaultEditor");
        int defaultTabIndex = "wysiwyg".equals(defaultEditor) ? 0 : 1;
        return Integer.parseInt(this.cache.get(CACHE_KEY_ACTIVE_TEXT_AREA, String.valueOf(defaultTabIndex)));
    }

    public void setSelectedTabIndex(int selectedTabIndex) {
        this.cache.put(CACHE_KEY_ACTIVE_TEXT_AREA, String.valueOf(selectedTabIndex));
    }

    public String getTemplateURL() {
        return this.config.getParameter("inputURL");
    }

    public boolean isDebugMode() {
        return Boolean.valueOf(this.config.getParameter("debug", String.valueOf(false)));
    }

    public Config getConfigurationSource() {
        return this.config;
    }

    public void onWindowClosing(Window.ClosingEvent event) {
        this.cache.update();
    }
}

