/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.VerticalResizePanel;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.CurrentPageImageSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.widget.PageSelector;
import org.xwiki.gwt.wysiwyg.client.widget.SpaceSelector;
import org.xwiki.gwt.wysiwyg.client.widget.WikiSelector;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.AttachmentReference;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class ImagesExplorerWizardStep
extends AbstractSelectorWizardStep<EntityLink<ImageConfig>>
implements ChangeHandler,
SourcesNavigationEvents {
    private static final String STYLE_LOADING = "loading";
    private WikiSelector wikiSelector;
    private SpaceSelector spaceSelector;
    private PageSelector pageSelector;
    private boolean displayWikiSelector;
    private CurrentPageImageSelectorWizardStep pageWizardStep;
    private final WikiServiceAsync wikiService;

    public ImagesExplorerWizardStep(boolean displayWikiSelector, WikiServiceAsync wikiService) {
        super((FlowPanel)new VerticalResizePanel());
        this.wikiService = wikiService;
        this.setStepTitle(Strings.INSTANCE.imageSelectImageTitle());
        Label helpLabel = new Label(Strings.INSTANCE.imageSelectImageLocationHelpLabel());
        helpLabel.addStyleName("xHelpLabel");
        this.display().add((Widget)helpLabel);
        this.display().addStyleName("xImagesExplorer");
        this.displayWikiSelector = displayWikiSelector;
        this.display().add((Widget)this.getSelectorsPanel());
        this.pageWizardStep = new CurrentPageImageSelectorWizardStep(wikiService, true);
        this.display().add((Widget)this.pageWizardStep.display());
        this.display().setExpandingWidget((Widget)this.pageWizardStep.display(), true);
    }

    private Panel getSelectorsPanel() {
        FlowPanel selectorsPanel = new FlowPanel();
        if (this.displayWikiSelector) {
            this.wikiSelector = new WikiSelector(this.wikiService);
            this.wikiSelector.addChangeHandler(this);
            selectorsPanel.add((Widget)this.wikiSelector);
        }
        this.spaceSelector = new SpaceSelector(this.wikiService);
        this.spaceSelector.addChangeHandler(this);
        selectorsPanel.add((Widget)this.spaceSelector);
        this.pageSelector = new PageSelector(this.wikiService);
        selectorsPanel.add((Widget)this.pageSelector);
        Button updateImagesListButton = new Button(Strings.INSTANCE.imageUpdateListButton());
        updateImagesListButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                WikiPageReference originPage = new WikiPageReference(((EntityLink)ImagesExplorerWizardStep.this.getData()).getOrigin());
                AttachmentReference imageReferenceTemplate = new AttachmentReference();
                imageReferenceTemplate.getWikiPageReference().setWikiName(ImagesExplorerWizardStep.this.displayWikiSelector ? ImagesExplorerWizardStep.this.wikiSelector.getSelectedWiki() : originPage.getWikiName());
                imageReferenceTemplate.getWikiPageReference().setSpaceName(ImagesExplorerWizardStep.this.spaceSelector.getSelectedSpace());
                imageReferenceTemplate.getWikiPageReference().setPageName(ImagesExplorerWizardStep.this.pageSelector.getSelectedPage());
                ImagesExplorerWizardStep.this.initCurrentPage(imageReferenceTemplate, null);
            }
        });
        selectorsPanel.add((Widget)updateImagesListButton);
        selectorsPanel.addStyleName("xPageChooser");
        return selectorsPanel;
    }

    public void setSelection(final AttachmentReference imageReference, final AsyncCallback<?> cb) {
        if (this.displayWikiSelector) {
            this.wikiService.isMultiWiki(new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                    if (cb != null) {
                        cb.onFailure(caught);
                    }
                }

                public void onSuccess(Boolean result) {
                    if (result.booleanValue()) {
                        ImagesExplorerWizardStep.this.setWikiSelection(imageReference, cb);
                    } else {
                        ImagesExplorerWizardStep.this.setSpaceSelection(imageReference, cb);
                    }
                }
            });
        } else {
            this.setSpaceSelection(imageReference, cb);
        }
    }

    private void setWikiSelection(final AttachmentReference imageReference, final AsyncCallback<?> cb) {
        this.wikiSelector.refreshList(imageReference.getWikiPageReference().getWikiName(), new AsyncCallback<List<String>>(){

            public void onSuccess(List<String> result) {
                ImagesExplorerWizardStep.this.setSpaceSelection(imageReference, cb);
            }

            public void onFailure(Throwable caught) {
                if (cb != null) {
                    cb.onFailure(caught);
                }
            }
        });
    }

    private void setSpaceSelection(AttachmentReference imageReference, final AsyncCallback<?> cb) {
        final AttachmentReference actualImageReference = imageReference.clone();
        WikiPageReference wikiPageReference = actualImageReference.getWikiPageReference();
        this.spaceSelector.setWiki(this.displayWikiSelector ? this.wikiSelector.getSelectedWiki() : wikiPageReference.getWikiName());
        wikiPageReference.setWikiName(this.spaceSelector.getWiki());
        this.spaceSelector.refreshList(wikiPageReference.getSpaceName(), new AsyncCallback<List<String>>(){

            public void onSuccess(List<String> result) {
                ImagesExplorerWizardStep.this.setPageSelection(actualImageReference, cb);
            }

            public void onFailure(Throwable caught) {
                if (cb != null) {
                    cb.onFailure(caught);
                }
            }
        });
    }

    private void setPageSelection(final AttachmentReference imageReference, final AsyncCallback<?> cb) {
        this.pageSelector.setWiki(this.spaceSelector.getWiki());
        this.pageSelector.setSpace(this.spaceSelector.getSelectedSpace());
        imageReference.getWikiPageReference().setSpaceName(this.pageSelector.getSpace());
        this.pageSelector.refreshList(imageReference.getWikiPageReference().getPageName(), new AsyncCallback<List<String>>(){

            public void onSuccess(List<String> result) {
                imageReference.getWikiPageReference().setPageName(ImagesExplorerWizardStep.this.pageSelector.getSelectedPage());
                ImagesExplorerWizardStep.this.initCurrentPage(imageReference, cb);
            }

            public void onFailure(Throwable caught) {
                if (cb != null) {
                    cb.onFailure(caught);
                }
            }
        });
    }

    public void onChange(ChangeEvent event) {
        if (event.getSource() == this.wikiSelector) {
            this.spaceSelector.setWiki(this.wikiSelector.getSelectedWiki());
            this.spaceSelector.refreshList(this.spaceSelector.getSelectedSpace(), new AsyncCallback<List<String>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<String> result) {
                    ImagesExplorerWizardStep.this.pageSelector.setWiki(ImagesExplorerWizardStep.this.wikiSelector.getSelectedWiki());
                    ImagesExplorerWizardStep.this.pageSelector.setSpace(ImagesExplorerWizardStep.this.spaceSelector.getSelectedSpace());
                    ImagesExplorerWizardStep.this.pageSelector.refreshList(ImagesExplorerWizardStep.this.pageSelector.getSelectedPage());
                }
            });
        } else if (event.getSource() == this.spaceSelector) {
            this.pageSelector.setWiki(this.spaceSelector.getWiki());
            this.pageSelector.setSpace(this.spaceSelector.getSelectedSpace());
            this.pageSelector.refreshList(this.pageSelector.getSelectedPage());
        }
    }

    protected void initCurrentPage(AttachmentReference imageReference, final AsyncCallback<?> cb) {
        this.display().addStyleName(STYLE_LOADING);
        ((EntityLink)this.getData()).getDestination().setEntityReference(imageReference.getEntityReference());
        this.pageWizardStep.init(this.getData(), new AsyncCallback<Object>(){

            public void onSuccess(Object result) {
                ImagesExplorerWizardStep.this.onCurrenPageInitialization();
                if (cb != null) {
                    cb.onSuccess(null);
                }
            }

            public void onFailure(Throwable caught) {
                if (cb != null) {
                    cb.onFailure(caught);
                } else {
                    ImagesExplorerWizardStep.this.showCurrentPageInitializationError();
                }
            }
        });
    }

    private void showCurrentPageInitializationError() {
        this.display().removeStyleName(STYLE_LOADING);
        Label error = new Label(Strings.INSTANCE.linkErrorLoadingData());
        error.addStyleName("errormessage");
        this.display().remove((Widget)this.pageWizardStep.display());
        this.display().add((Widget)error);
    }

    private void onCurrenPageInitialization() {
        if (this.display().getWidgetIndex((Widget)this.pageWizardStep.display()) < 0) {
            this.display().remove(this.display().getWidgetCount() - 1);
            this.display().add((Widget)this.pageWizardStep.display());
        }
        this.display().removeStyleName(STYLE_LOADING);
    }

    public VerticalResizePanel display() {
        return (VerticalResizePanel)super.display();
    }

    public String getNextStep() {
        return this.pageWizardStep.getNextStep();
    }

    @Override
    protected void initializeSelection(AsyncCallback<?> cb) {
        if (!StringUtils.isEmpty((String)((ImageConfig)((EntityLink)this.getData()).getData()).getReference()) && ((EntityLink)this.getData()).getDestination().getEntityReference().getType() == EntityReference.EntityType.ATTACHMENT) {
            this.setSelection(new AttachmentReference(((EntityLink)this.getData()).getDestination().getEntityReference()), cb);
        } else if (this.pageSelector.getSelectedPage() == null) {
            this.setSelection(new AttachmentReference(((EntityLink)this.getData()).getOrigin()), cb);
        } else {
            EntityReference destinationReference = ((EntityLink)this.pageWizardStep.getData()).getDestination().getEntityReference();
            this.initCurrentPage(new AttachmentReference(destinationReference), cb);
        }
    }

    public void onCancel() {
        this.pageWizardStep.onCancel();
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        this.pageWizardStep.onSubmit(async);
    }

    public void addNavigationListener(NavigationListener listener) {
        this.pageWizardStep.addNavigationListener(listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.pageWizardStep.removeNavigationListener(listener);
    }

    @Override
    public void setActive() {
        if (this.displayWikiSelector) {
            this.wikiSelector.setFocus(true);
        } else {
            this.spaceSelector.setFocus(true);
        }
    }

    @Override
    public Object getResult() {
        return this.pageWizardStep.getResult();
    }
}

