/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ShortcutKeyManager;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroController;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDisplayer;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroMenuExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroSelector;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroServiceAsync;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroToolBarExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroWizard;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.exec.CollapseExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.exec.InsertExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.exec.RefreshExecutable;

public class MacroPlugin
extends AbstractPlugin {
    public static final Command REFRESH = new Command("macroRefresh");
    public static final Command COLLAPSE = new Command("macroCollapseAll");
    public static final Command EXPAND = new Command("macroExpandAll");
    public static final Command INSERT = new Command("macroInsert");
    private MacroDisplayer displayer;
    private MacroSelector selector;
    private MacroWizard wizard;
    private MacroMenuExtension menuExtension;
    private MacroToolBarExtension toolBarExtension;
    private final MacroServiceAsync macroService;
    private final MacroController macroControler;
    private final ShortcutKeyManager shortcutKeyManager = new ShortcutKeyManager();

    public MacroPlugin(MacroServiceAsync macroService) {
        this.macroService = macroService;
        this.macroControler = new MacroController(this);
    }

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.displayer = new MacroDisplayer(this.getTextArea());
        this.selector = new MacroSelector(this.displayer);
        this.wizard = new MacroWizard(this.displayer, config, this.macroService);
        String templateURL = config.getParameter("inputURL");
        if (!StringUtils.isEmpty((String)templateURL)) {
            this.getTextArea().getCommandManager().registerCommand(REFRESH, (Executable)new RefreshExecutable(textArea, templateURL));
        }
        this.getTextArea().getCommandManager().registerCommand(COLLAPSE, (Executable)new CollapseExecutable(this.selector, true));
        this.getTextArea().getCommandManager().registerCommand(EXPAND, (Executable)new CollapseExecutable(this.selector, false));
        this.getTextArea().getCommandManager().registerCommand(INSERT, (Executable)new InsertExecutable(this.selector, this.macroService, config));
        this.saveRegistrations(this.shortcutKeyManager.addHandlers((HasAllKeyHandlers)this.getTextArea()));
        this.saveRegistrations(this.macroControler.addHadlers());
        this.menuExtension = new MacroMenuExtension(this);
        this.getUIExtensionList().add(this.menuExtension);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                MacroPlugin.this.menuExtension.registerAttachHandlers();
            }
        });
        this.toolBarExtension = new MacroToolBarExtension(this);
        if (this.toolBarExtension.getExtension().getFeatures().length > 0) {
            this.getUIExtensionList().add(this.toolBarExtension.getExtension());
        }
    }

    public void destroy() {
        this.menuExtension.clearFeatures();
        this.toolBarExtension.destroy();
        this.shortcutKeyManager.clear();
        this.getTextArea().getCommandManager().unregisterCommand(REFRESH);
        this.getTextArea().getCommandManager().unregisterCommand(COLLAPSE);
        this.getTextArea().getCommandManager().unregisterCommand(EXPAND);
        this.getTextArea().getCommandManager().unregisterCommand(INSERT);
        this.selector.destroy();
        this.selector = null;
        this.displayer.destroy();
        this.displayer = null;
        this.wizard.destroy();
        this.wizard = null;
        super.destroy();
    }

    public MacroSelector getSelector() {
        return this.selector;
    }

    ShortcutKeyManager getShortcutKeyManager() {
        return this.shortcutKeyManager;
    }

    public MacroServiceAsync getMacroService() {
        return this.macroService;
    }

    public void edit() {
        this.wizard.edit();
    }

    public void insert() {
        this.wizard.insert();
    }

    public void insert(String macroId) {
        this.wizard.insert(macroId);
    }
}

