/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.widget.wizard.util;

import java.util.ArrayList;
import java.util.List;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractSelectorAggregatorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;

public class AttachmentSelectorAggregatorWizardStep<T extends EntityConfig>
extends AbstractSelectorAggregatorWizardStep<EntityLink<T>> {
    private final boolean selectionLimitedToCurrentPage;
    private WizardStep currentPageSelector;
    private WizardStep allPagesSelector;

    public AttachmentSelectorAggregatorWizardStep(boolean selectionLimitedToCurrentPage) {
        this.selectionLimitedToCurrentPage = selectionLimitedToCurrentPage;
    }

    @Override
    protected String getRequiredStep() {
        WikiPageReference originPage = new WikiPageReference(((EntityLink)this.getData()).getOrigin());
        WikiPageReference destinationPage = new WikiPageReference(((EntityLink)this.getData()).getDestination().getEntityReference());
        if (this.selectionLimitedToCurrentPage || originPage.equals(destinationPage)) {
            return Strings.INSTANCE.selectorSelectFromCurrentPage();
        }
        return Strings.INSTANCE.selectorSelectFromAllPages();
    }

    @Override
    protected WizardStep getStepInstance(String name) {
        if (name.equals(Strings.INSTANCE.selectorSelectFromCurrentPage())) {
            return this.currentPageSelector;
        }
        if (name.equals(Strings.INSTANCE.selectorSelectFromAllPages())) {
            return this.allPagesSelector;
        }
        return null;
    }

    public void setCurrentPageSelector(WizardStep currentPageSelector) {
        this.currentPageSelector = currentPageSelector;
    }

    public void setAllPagesSelector(WizardStep allPagesSelector) {
        this.allPagesSelector = allPagesSelector;
    }

    @Override
    protected List<String> getStepNames() {
        ArrayList<String> stepNames = new ArrayList<String>();
        stepNames.add(Strings.INSTANCE.selectorSelectFromCurrentPage());
        if (!this.selectionLimitedToCurrentPage) {
            stepNames.add(Strings.INSTANCE.selectorSelectFromAllPages());
        }
        return stepNames;
    }
}

