/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.user.client.FocusCommand;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.wizard.AbstractInteractiveWizardStep;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.AttachmentReference;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class LinkConfigWizardStep
extends AbstractInteractiveWizardStep
implements SourcesNavigationEvents,
KeyPressHandler {
    public static final String DEFAULT_STYLE_NAME = "xLinkConfig";
    public static final String INFO_LABEL_STYLE = "xInfoLabel";
    public static final String HELP_LABEL_STYLE = "xHelpLabel";
    public static final String ERROR_LABEL_STYLE = "xErrorMsg";
    protected static final String FIELD_ERROR_STYLE = "xErrorField";
    private EntityLink<LinkConfig> entityLink;
    private final NavigationListenerCollection navigationListeners = new NavigationListenerCollection();
    private final TextBox labelTextBox = new TextBox();
    private final Label labelErrorLabel = new Label();
    private final TextBox tooltipTextBox = new TextBox();
    private CheckBox newWindowCheckBox;
    private final WikiServiceAsync wikiService;

    public LinkConfigWizardStep(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
        this.setStepTitle(Strings.INSTANCE.linkConfigTitle());
        this.display().addStyleName(DEFAULT_STYLE_NAME);
        this.setUpLabelField();
        Label tooltipLabel = new Label(Strings.INSTANCE.linkTooltipLabel());
        tooltipLabel.setStyleName(INFO_LABEL_STYLE);
        Label helpTooltipLabel = new Label(this.getTooltipTextBoxTooltip());
        helpTooltipLabel.setStyleName(HELP_LABEL_STYLE);
        this.tooltipTextBox.addKeyPressHandler((KeyPressHandler)this);
        this.tooltipTextBox.setTitle(this.getTooltipTextBoxTooltip());
        this.display().add((Widget)tooltipLabel);
        this.display().add((Widget)helpTooltipLabel);
        this.display().add((Widget)this.tooltipTextBox);
        this.newWindowCheckBox = new CheckBox(Strings.INSTANCE.linkOpenInNewWindowLabel());
        this.newWindowCheckBox.addStyleName(INFO_LABEL_STYLE);
        Label helpNewWindowLabel = new Label(Strings.INSTANCE.linkOpenInNewWindowHelpLabel());
        helpNewWindowLabel.setStyleName(HELP_LABEL_STYLE);
        this.display().add((Widget)this.newWindowCheckBox);
        this.display().add((Widget)helpNewWindowLabel);
    }

    private void setUpLabelField() {
        FlowPanel labelLabel = new FlowPanel();
        labelLabel.setStyleName(INFO_LABEL_STYLE);
        labelLabel.add((Widget)new InlineLabel(Strings.INSTANCE.linkLabelLabel()));
        InlineLabel mandatoryLabel = new InlineLabel(Strings.INSTANCE.mandatory());
        mandatoryLabel.addStyleName("xMandatory");
        labelLabel.add((Widget)mandatoryLabel);
        Label helpLabelLabel = new Label(this.getLabelTextBoxTooltip());
        helpLabelLabel.setStyleName(HELP_LABEL_STYLE);
        this.labelErrorLabel.addStyleName(ERROR_LABEL_STYLE);
        this.labelErrorLabel.setVisible(false);
        this.labelTextBox.addKeyPressHandler((KeyPressHandler)this);
        this.labelTextBox.setTitle(this.getLabelTextBoxTooltip());
        this.display().add((Widget)labelLabel);
        this.display().add((Widget)helpLabelLabel);
        this.display().add((Widget)this.labelErrorLabel);
        this.display().add((Widget)this.labelTextBox);
    }

    public void init(Object data, final AsyncCallback<?> callback) {
        this.entityLink = (EntityLink)data;
        LinkConfig linkConfig = this.entityLink.getData();
        if (linkConfig.isReadOnlyLabel()) {
            this.wikiService.parseLinkReference(linkConfig.getLabelText(), this.entityLink.getOrigin(), new AsyncCallback<ResourceReference>(){

                public void onFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onSuccess(ResourceReference result) {
                    LinkConfigWizardStep.this.init(result, callback);
                }
            });
        } else {
            this.init(this.entityLink.getDestination(), callback);
        }
    }

    private void init(ResourceReference labelResourceReference, AsyncCallback<?> callback) {
        LinkConfig linkConfig = this.entityLink.getData();
        boolean useFileName = labelResourceReference.getType() == ResourceReference.ResourceType.ATTACHMENT && (linkConfig.isReadOnlyLabel() || StringUtils.isEmpty((String)linkConfig.getLabel()));
        this.labelTextBox.setText(useFileName ? new AttachmentReference(labelResourceReference.getEntityReference()).getFileName() : linkConfig.getLabelText());
        this.labelTextBox.setEnabled(!linkConfig.isReadOnlyLabel());
        this.tooltipTextBox.setText(linkConfig.getTooltip() == null ? "" : linkConfig.getTooltip());
        this.newWindowCheckBox.setValue(Boolean.valueOf(linkConfig.isOpenInNewWindow()));
        this.hideErrors();
        callback.onSuccess(null);
        this.setFocus();
    }

    protected void setFocus() {
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new FocusCommand((Focusable)(this.labelTextBox.isEnabled() ? this.labelTextBox : this.tooltipTextBox)));
    }

    protected TextBox getLabelTextBox() {
        return this.labelTextBox;
    }

    protected String getLabelTextBoxTooltip() {
        return Strings.INSTANCE.linkConfigLabelTextBoxTooltip();
    }

    protected String getTooltipTextBoxTooltip() {
        return Strings.INSTANCE.linkConfigTooltipTextBoxTooltip();
    }

    public TextBox getTooltipTextBox() {
        return this.tooltipTextBox;
    }

    public CheckBox getNewWindowCheckBox() {
        return this.newWindowCheckBox;
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        this.hideErrors();
        if (!this.validateForm()) {
            async.onSuccess((Object)false);
            this.setFocus();
        } else {
            this.saveForm(async);
        }
    }

    protected boolean validateForm() {
        if (this.labelTextBox.getText().trim().length() == 0) {
            this.displayLabelError(Strings.INSTANCE.linkNoLabelError());
            return false;
        }
        return true;
    }

    protected void saveForm(AsyncCallback<Boolean> callback) {
        LinkConfig linkConfig = this.entityLink.getData();
        if (!linkConfig.isReadOnlyLabel() && !this.labelTextBox.getText().trim().equals(linkConfig.getLabelText().trim())) {
            linkConfig.setLabel(this.labelTextBox.getText().trim());
            linkConfig.setLabelText(this.labelTextBox.getText().trim());
        }
        linkConfig.setTooltip(this.getTooltipTextBox().getText());
        linkConfig.setOpenInNewWindow(this.getNewWindowCheckBox().getValue());
        callback.onSuccess((Object)true);
    }

    public void onCancel() {
    }

    public Object getResult() {
        return this.entityLink;
    }

    public NavigationListener.NavigationDirection getDefaultDirection() {
        return NavigationListener.NavigationDirection.FINISH;
    }

    public void addNavigationListener(NavigationListener listener) {
        this.navigationListeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.navigationListeners.remove((Object)listener);
    }

    public void onKeyPress(KeyPressEvent event) {
        if (event.getNativeEvent().getKeyCode() == 13) {
            this.navigationListeners.fireNavigationEvent(this.getDefaultDirection());
        }
    }

    protected void displayLabelError(String errorMessage) {
        this.labelErrorLabel.setText(errorMessage);
        this.labelErrorLabel.setVisible(true);
        this.labelTextBox.addStyleName(FIELD_ERROR_STYLE);
    }

    protected void hideErrors() {
        this.labelErrorLabel.setVisible(false);
        this.labelTextBox.removeStyleName(FIELD_ERROR_STYLE);
    }

    protected Label getLabelErrorLabel() {
        return this.labelErrorLabel;
    }

    protected EntityLink<LinkConfig> getData() {
        return this.entityLink;
    }

    protected WikiServiceAsync getWikiService() {
        return this.wikiService;
    }
}

