/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.valign;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.UIObject;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractStatefulPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;

public class VerticalAlignPlugin
extends AbstractStatefulPlugin
implements ClickHandler {
    private final Map<ToggleButton, Command> buttons = new HashMap<ToggleButton, Command>();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.addFeature("superscript", Command.SUPER_SCRIPT, Images.INSTANCE.superscript(), Strings.INSTANCE.superscript());
        this.addFeature("subscript", Command.SUB_SCRIPT, Images.INSTANCE.subscript(), Strings.INSTANCE.subscript());
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.registerTextAreaHandlers();
            this.getUIExtensionList().add(this.toolBarExtension);
        }
    }

    private void addFeature(String name, Command command, ImageResource imageResource, String title) {
        if (this.getTextArea().getCommandManager().isSupported(command)) {
            ToggleButton button = new ToggleButton(new Image(imageResource));
            this.saveRegistration(button.addClickHandler((ClickHandler)this));
            button.setTitle(title);
            this.toolBarExtension.addFeature(name, (UIObject)button);
            this.buttons.put(button, command);
        }
    }

    public void destroy() {
        for (ToggleButton button : this.buttons.keySet()) {
            button.removeFromParent();
        }
        this.buttons.clear();
        this.toolBarExtension.clearFeatures();
        super.destroy();
    }

    public void onClick(ClickEvent event) {
        Command command = this.buttons.get(event.getSource());
        if (command != null && ((FocusWidget)event.getSource()).isEnabled()) {
            this.getTextArea().setFocus(true);
            this.getTextArea().getCommandManager().execute(command);
        }
    }

    public void update() {
        for (Map.Entry<ToggleButton, Command> entry : this.buttons.entrySet()) {
            if (!entry.getKey().isEnabled()) continue;
            entry.getKey().setDown(this.getTextArea().getCommandManager().isExecuted(entry.getValue()));
        }
    }
}

