/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.embed;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.InnerHTMLListener;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;

public class EmbedPlugin
extends AbstractPlugin
implements CommandListener,
InnerHTMLListener {
    public static final Command RESET = new Command("reset");

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.getTextArea().getCommandManager().addCommandListener((CommandListener)this);
        this.getTextArea().getDocument().addInnerHTMLListener((InnerHTMLListener)this);
        this.replaceEmbeddedObjects((Element)this.getTextArea().getDocument().getBody());
    }

    public void destroy() {
        this.getTextArea().getCommandManager().removeCommandListener((CommandListener)this);
        this.getTextArea().getDocument().removeInnerHTMLListener((InnerHTMLListener)this);
        super.destroy();
    }

    public boolean onBeforeCommand(CommandManager sender, Command command, String param) {
        return false;
    }

    public void onCommand(CommandManager sender, Command command, String param) {
        if (RESET.equals((Object)command)) {
            this.replaceEmbeddedObjects((Element)this.getTextArea().getDocument().getBody());
        }
    }

    public void onInnerHTMLChange(org.xwiki.gwt.dom.client.Element element) {
        this.replaceEmbeddedObjects((Element)element);
    }

    private void replaceEmbeddedObjects(Element root) {
        for (Element embed : this.getEmbeddedObjects(root)) {
            this.replaceEmbeddedObject(embed);
        }
    }

    private void replaceEmbeddedObject(Element embed) {
        ImageElement placeHolder = embed.getOwnerDocument().createImageElement();
        placeHolder.setSrc(GWT.getModuleBaseURL() + "clear.cache.gif");
        placeHolder.setAlt(Strings.INSTANCE.embeddedObject());
        placeHolder.setTitle(placeHolder.getAlt());
        placeHolder.setClassName("xEmbeddedObject");
        this.setSize((Element)placeHolder, "width", embed.getPropertyString("width"));
        this.setSize((Element)placeHolder, "height", embed.getPropertyString("height"));
        embed.getParentNode().replaceChild((Node)placeHolder, (Node)embed);
        DocumentFragment metadata = this.getTextArea().getDocument().createDocumentFragment();
        metadata.appendChild((Node)embed);
        org.xwiki.gwt.dom.client.Element.as((Node)placeHolder).setMetaData(metadata);
    }

    private List<Element> getEmbeddedObjects(Element root) {
        return this.getMaximalElementsByTagName(root, "object", "embed");
    }

    private void setSize(Element element, String property, String value) {
        if (!StringUtils.isEmpty((String)value)) {
            try {
                element.getStyle().setPropertyPx(property, Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                element.getStyle().setProperty(property, value);
            }
        }
    }

    private List<Element> getMaximalElementsByTagName(Element root, String ... tagNames) {
        List<String> tagNameList = Arrays.asList(tagNames);
        ArrayList<Element> maximalElements = new ArrayList<Element>();
        Element node = root;
        while (true) {
            if (node.getNodeType() == 1 && tagNameList.contains(node.getNodeName().toLowerCase())) {
                maximalElements.add(Element.as((Node)node));
            } else if (node.hasChildNodes()) {
                node = node.getFirstChild();
                continue;
            }
            while (node != root && node.getNextSibling() == null) {
                node = node.getParentNode();
            }
            if (node == root) break;
            node = node.getNextSibling();
        }
        return maximalElements;
    }
}

