/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroServiceAsync;

public class MacroServiceAsyncCacheProxy
implements MacroServiceAsync {
    private final MacroServiceAsync service;
    private final Map<String, List<MacroDescriptor>> macroDescriptorList = new HashMap<String, List<MacroDescriptor>>();
    private final Map<String, Map<String, MacroDescriptor>> macroDescriptorMap = new HashMap<String, Map<String, MacroDescriptor>>();

    public MacroServiceAsyncCacheProxy(MacroServiceAsync service) {
        this.service = service;
    }

    @Override
    public void getMacroDescriptor(String macroId, final String syntaxId, String wikiId, final AsyncCallback<MacroDescriptor> async) {
        MacroDescriptor descriptor;
        Map<String, MacroDescriptor> macroDescriptorMapForSyntax = this.macroDescriptorMap.get(syntaxId);
        if (macroDescriptorMapForSyntax != null && (descriptor = macroDescriptorMapForSyntax.get(macroId)) != null) {
            async.onSuccess((Object)descriptor);
            return;
        }
        List<MacroDescriptor> macroDescriptorListForSyntax = this.macroDescriptorList.get(syntaxId);
        if (macroDescriptorListForSyntax != null) {
            for (MacroDescriptor descriptor2 : macroDescriptorListForSyntax) {
                if (!macroId.equals(descriptor2.getId())) continue;
                this.cacheMacroDescriptor(descriptor2, syntaxId);
                async.onSuccess((Object)descriptor2);
                return;
            }
        }
        this.service.getMacroDescriptor(macroId, syntaxId, wikiId, new AsyncCallback<MacroDescriptor>(){

            public void onFailure(Throwable caught) {
                async.onFailure(caught);
            }

            public void onSuccess(MacroDescriptor result) {
                if (result != null) {
                    MacroServiceAsyncCacheProxy.this.cacheMacroDescriptor(result, syntaxId);
                }
                async.onSuccess((Object)result);
            }
        });
    }

    @Override
    public void getMacroDescriptor(String macroId, String syntaxId, AsyncCallback<MacroDescriptor> async) {
        this.getMacroDescriptor(macroId, syntaxId, null, async);
    }

    private void cacheMacroDescriptor(MacroDescriptor descriptor, String syntaxId) {
        Map<String, MacroDescriptor> macroDescriptorsForSyntax = this.macroDescriptorMap.get(syntaxId);
        if (macroDescriptorsForSyntax == null) {
            macroDescriptorsForSyntax = new HashMap<String, MacroDescriptor>();
            this.macroDescriptorMap.put(syntaxId, macroDescriptorsForSyntax);
        }
        macroDescriptorsForSyntax.put(descriptor.getId(), descriptor);
    }

    @Override
    public void getMacroDescriptors(final String syntaxId, String wikiId, final AsyncCallback<List<MacroDescriptor>> async) {
        List<MacroDescriptor> macroDescriptorListForSyntax = this.macroDescriptorList.get(syntaxId);
        if (macroDescriptorListForSyntax != null) {
            async.onSuccess(macroDescriptorListForSyntax);
        } else {
            this.service.getMacroDescriptors(syntaxId, wikiId, new AsyncCallback<List<MacroDescriptor>>(){

                public void onFailure(Throwable caught) {
                    async.onFailure(caught);
                }

                public void onSuccess(List<MacroDescriptor> result) {
                    if (result != null) {
                        MacroServiceAsyncCacheProxy.this.macroDescriptorList.put(syntaxId, result);
                    }
                    async.onSuccess(result);
                }
            });
        }
    }

    @Override
    public void getMacroDescriptors(String syntaxId, AsyncCallback<List<MacroDescriptor>> async) {
        this.getMacroDescriptors(syntaxId, null, async);
    }
}

