/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverter;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.wysiwyg.server.WysiwygEditorConfiguration;
import org.xwiki.wysiwyg.server.WysiwygEditorScriptService;

@Component
@Named(value="wysiwyg")
@Singleton
public class DefaultWysiwygEditorScriptService
implements WysiwygEditorScriptService {
    private static final String IS_IN_RENDERING_ENGINE = "isInRenderingEngine";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Execution execution;
    @Inject
    private HTMLConverter htmlConverter;
    @Inject
    private WysiwygEditorConfiguration editorConfiguration;

    @Deprecated
    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    @Override
    public boolean isSyntaxSupported(String syntaxId) {
        try {
            this.componentManager.lookup(Parser.class, syntaxId);
            this.componentManager.lookup(PrintRendererFactory.class, syntaxId);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String parseAndRender(String html, String syntax) {
        Object isInRenderingEngine = this.getXWikiContext().get((Object)IS_IN_RENDERING_ENGINE);
        try {
            this.getXWikiContext().put((Object)IS_IN_RENDERING_ENGINE, (Object)true);
            String string = this.htmlConverter.parseAndRender(html, syntax);
            return string;
        }
        catch (Exception e) {
            String string = html;
            return string;
        }
        finally {
            if (isInRenderingEngine != null) {
                this.getXWikiContext().put((Object)IS_IN_RENDERING_ENGINE, isInRenderingEngine);
            } else {
                this.getXWikiContext().remove((Object)IS_IN_RENDERING_ENGINE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toAnnotatedXHTML(String source, String syntaxId) {
        Object isInRenderingEngine = this.getXWikiContext().get((Object)IS_IN_RENDERING_ENGINE);
        try {
            this.getXWikiContext().put((Object)IS_IN_RENDERING_ENGINE, (Object)true);
            String string = this.htmlConverter.toHTML(source, syntaxId);
            return string;
        }
        catch (Exception e) {
            String string = source;
            return string;
        }
        finally {
            if (isInRenderingEngine != null) {
                this.getXWikiContext().put((Object)IS_IN_RENDERING_ENGINE, isInRenderingEngine);
            } else {
                this.getXWikiContext().remove((Object)IS_IN_RENDERING_ENGINE);
            }
        }
    }

    @Override
    public WysiwygEditorConfiguration getConfig() {
        return this.editorConfiguration;
    }
}

