/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.cleaner;

import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.xml.html.filter.HTMLFilter;

public class NestedAnchorsFilter
implements HTMLFilter {
    private static final Log LOG = LogFactory.getLog(NestedAnchorsFilter.class);

    public void filter(Document document, Map<String, String> parameters) {
        try {
            NodeList nestedAnchors = XPathAPI.selectNodeList((Node)document, (String)"//a//a");
            for (int i = 0; i < nestedAnchors.getLength(); ++i) {
                Element nestedAnchor = (Element)nestedAnchors.item(i);
                this.unwrap(nestedAnchor);
            }
        }
        catch (TransformerException e) {
            LOG.error((Object)"Exception while filtering nested anchors.", (Throwable)e);
        }
    }

    private void unwrap(Element element) {
        Document ownerDocument = element.getOwnerDocument();
        if (ownerDocument == null) {
            return;
        }
        Element parent = (Element)element.getParentNode();
        if (parent == null) {
            return;
        }
        DocumentFragment children = element.getOwnerDocument().createDocumentFragment();
        while (element.hasChildNodes()) {
            children.appendChild(element.getChildNodes().item(0));
        }
        parent.replaceChild(children, element);
    }
}

