/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.cleaner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.xml.html.filter.HTMLFilter;

public class StandAloneMacroFilter
implements HTMLFilter {
    public void filter(Document document, Map<String, String> parameters) {
        List<Element> wrappers = this.getStandAloneMacroWrappers(document);
        for (int i = 0; i < wrappers.size(); ++i) {
            Element paragraph = wrappers.get(i);
            paragraph.getParentNode().insertBefore(paragraph.getFirstChild(), paragraph);
            paragraph.getParentNode().insertBefore(paragraph.getLastChild(), paragraph);
            paragraph.getParentNode().removeChild(paragraph);
        }
    }

    private List<Element> getStandAloneMacroWrappers(Document document) {
        NodeList paragraphs = document.getElementsByTagName("p");
        ArrayList<Element> wrappers = new ArrayList<Element>();
        for (int i = 0; i < paragraphs.getLength(); ++i) {
            Element paragraph = (Element)paragraphs.item(i);
            Node child = paragraph.getFirstChild();
            if (child == null || child.getNodeType() != 8 || !child.getNodeValue().startsWith("startmacro:")) continue;
            while (!((child = child.getNextSibling()) == null || child.getNodeType() == 8 && child.getNodeValue().equals("stopmacro"))) {
            }
            if (child == null || child.getNextSibling() != null) continue;
            wrappers.add(paragraph);
        }
        return wrappers;
    }
}

