/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.converter;

import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.gwt.wysiwyg.client.cleaner.HTMLCleaner;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverter;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxFactory;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;

public class DefaultHTMLConverter
implements HTMLConverter {
    private static final Log LOG = LogFactory.getLog(DefaultHTMLConverter.class);
    @Requirement
    private HTMLCleaner htmlCleaner;
    @Requirement(value="xhtml/1.0")
    private Parser xhtmlParser;
    @Requirement(value="xhtml/1.0")
    private StreamParser xhtmlStreamParser;
    @Requirement
    private SyntaxFactory syntaxFactory;
    @Requirement(value="macro")
    private Transformation macroTransformation;
    @Requirement(value="annotatedxhtml/1.0")
    private BlockRenderer xhtmlRenderer;
    @Requirement
    private ComponentManager componentManager;

    public String fromHTML(String dirtyHTML, String syntaxId) {
        try {
            String html = this.htmlCleaner.clean(dirtyHTML);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            PrintRendererFactory printRendererFactory = (PrintRendererFactory)this.componentManager.lookup(PrintRendererFactory.class, syntaxId);
            this.xhtmlStreamParser.parse((Reader)new StringReader(html), (Listener)printRendererFactory.createRenderer((WikiPrinter)printer));
            return printer.toString();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException("Exception while parsing HTML", e);
        }
    }

    public String toHTML(String source, String syntaxId) {
        try {
            Parser parser = (Parser)this.componentManager.lookup(Parser.class, syntaxId);
            XDOM xdom = parser.parse((Reader)new StringReader(source));
            TransformationContext txContext = new TransformationContext();
            txContext.setXDOM(xdom);
            txContext.setSyntax(this.syntaxFactory.createSyntaxFromIdString(syntaxId));
            this.macroTransformation.transform((Block)xdom, txContext);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.xhtmlRenderer.render((Block)xdom, (WikiPrinter)printer);
            return printer.toString();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException("Exception while rendering HTML", e);
        }
    }

    public String parseAndRender(String dirtyHTML, String syntaxId) {
        try {
            String html = this.htmlCleaner.clean(dirtyHTML);
            XDOM xdom = this.xhtmlParser.parse((Reader)new StringReader(html));
            Syntax syntax = this.syntaxFactory.createSyntaxFromIdString(syntaxId);
            xdom.getMetaData().addMetaData("syntax", (Object)syntax);
            TransformationContext txContext = new TransformationContext();
            txContext.setXDOM(xdom);
            txContext.setSyntax(syntax);
            this.macroTransformation.transform((Block)xdom, txContext);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.xhtmlRenderer.render((Block)xdom, (WikiPrinter)printer);
            return printer.toString();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException("Exception while refreshing HTML", e);
        }
    }
}

