/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.plugin.sync;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xwiki.gwt.wysiwyg.client.diff.Diff;
import org.xwiki.gwt.wysiwyg.client.diff.Revision;
import org.xwiki.gwt.wysiwyg.client.diff.ToString;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncResult;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncStatus;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncTools;
import org.xwiki.wysiwyg.server.plugin.sync.SyncEngine;
import org.xwiki.wysiwyg.server.plugin.sync.SyncException;

public class DefaultSyncEngine
implements SyncEngine {
    private static final Log LOG = LogFactory.getLog(DefaultSyncEngine.class);
    private Map<String, SyncStatus> syncMap = new HashMap<String, SyncStatus>();

    @Override
    public SyncStatus getSyncStatus(String key) {
        return this.syncMap.get(key);
    }

    @Override
    public void setSyncStatus(String key, SyncStatus syncStatus) {
        this.syncMap.put(key, syncStatus);
    }

    @Override
    public SyncResult sync(SyncStatus syncStatus, Revision revision, int version) throws SyncException {
        try {
            Revision rev;
            SyncResult result = new SyncResult();
            String originalContent = syncStatus.getVersion(version);
            LOG.debug((Object)("Current server version is: " + syncStatus.getCurrentVersionNumber()));
            LOG.debug((Object)("Client version is: " + version));
            if (version == syncStatus.getCurrentVersionNumber()) {
                LOG.debug((Object)"Nothing to apply from the server");
                if (revision == null) {
                    LOG.debug((Object)"Nothing to apply from the client");
                    return null;
                }
                LOG.debug((Object)("Applying patch from the client: " + revision));
                LOG.debug((Object)("Original content: " + originalContent));
                String newContent = ToString.arrayToString((Object[])revision.patch((Object[])ToString.stringToArray((String)originalContent)));
                LOG.debug((Object)("New content: " + newContent));
                syncStatus.addVersion(newContent);
                result.setVersion(syncStatus.getCurrentVersionNumber());
                result.setRevision(null);
                result.setStatus(true);
                return result;
            }
            String lastContent = syncStatus.getCurrentVersion();
            if (lastContent.equals(originalContent)) {
                rev = null;
            } else {
                rev = Diff.diff((Object[])ToString.stringToArray((String)originalContent), (Object[])ToString.stringToArray((String)lastContent));
                LOG.debug((Object)("Content on client is based on this content: " + originalContent));
                LOG.debug((Object)("Clients needs to update it's content with rev: " + rev));
            }
            if (revision == null) {
                result.setVersion(syncStatus.getCurrentVersionNumber());
                result.setRevision(rev);
                result.setStatus(true);
                return result;
            }
            LOG.debug((Object)("Original revision is: " + revision));
            LOG.debug((Object)("Other revision is: " + rev));
            if (rev != null) {
                revision = SyncTools.relocateRevision((Revision)revision, (Revision)rev);
            }
            LOG.debug((Object)("Relocated revision is: " + revision));
            LOG.debug((Object)("Content being patched: " + lastContent));
            String newContent = ToString.arrayToString((Object[])revision.patch((Object[])ToString.stringToArray((String)lastContent)));
            LOG.debug((Object)("New content is: " + newContent));
            Revision newRevision = Diff.diff((Object[])ToString.stringToArray((String)originalContent), (Object[])ToString.stringToArray((String)newContent));
            LOG.debug((Object)("New revision to apply on the client: " + newRevision));
            syncStatus.addVersion(newContent);
            result.setVersion(syncStatus.getCurrentVersionNumber());
            result.setRevision(newRevision);
            result.setStatus(true);
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while processing sync", (Throwable)e);
            throw new SyncException("Sync Failed", e);
        }
    }
}

