/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.plugin.macro;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiMessageTool;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor;
import org.xwiki.wysiwyg.server.plugin.macro.MacroDescriptorTranslator;

@Component
@Singleton
public class XWikiMacroDescriptorTranslator
implements MacroDescriptorTranslator {
    private static final String FIELD_NAME = ".name";
    private static final String FIELD_DESCRIPTION = ".description";
    private static final String KEY_RENDERING = "rendering";
    @Inject
    private Execution execution;
    private XWikiMessageTool messageTool;

    @Override
    public MacroDescriptor translate(MacroDescriptor macroDescriptor) {
        this.messageTool = ((XWikiContext)this.execution.getContext().getProperty("xwikicontext")).getMessageTool();
        String macroKey = "rendering.macro." + macroDescriptor.getId();
        macroDescriptor.setName(this.translate(macroKey + FIELD_NAME, macroDescriptor.getName()));
        macroDescriptor.setDescription(this.translate(macroKey + FIELD_DESCRIPTION, macroDescriptor.getDescription()));
        String macroCategoryKey = "rendering.macroCategory." + macroDescriptor.getCategory();
        macroDescriptor.setCategory(this.translate(macroCategoryKey, macroDescriptor.getCategory()));
        ParameterDescriptor contentDescriptor = macroDescriptor.getContentDescriptor();
        if (contentDescriptor != null) {
            contentDescriptor.setName(this.translate("rendering.macroContent", contentDescriptor.getName()));
            contentDescriptor.setDescription(this.translate(macroKey + ".content.description", contentDescriptor.getDescription()));
        }
        for (ParameterDescriptor paramDescriptor : macroDescriptor.getParameterDescriptorMap().values()) {
            String paramKey = macroKey + ".parameter." + paramDescriptor.getId();
            paramDescriptor.setName(this.translate(paramKey + FIELD_NAME, paramDescriptor.getName()));
            paramDescriptor.setDescription(this.translate(paramKey + FIELD_DESCRIPTION, paramDescriptor.getDescription()));
            if (!paramDescriptor.getType().isEnum()) continue;
            for (Map.Entry entry : paramDescriptor.getType().getEnumConstants().entrySet()) {
                String paramValueKey = paramKey + ".value." + (String)entry.getKey();
                entry.setValue(this.translate(paramValueKey, (String)entry.getValue()));
            }
        }
        return macroDescriptor;
    }

    private String translate(String key, String defaultValue) {
        String translation = this.messageTool.get(key);
        return key.equals(translation) ? defaultValue : translation;
    }
}

