/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.wiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.AttachmentReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPage;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.wysiwyg.server.internal.wiki.AbstractWikiService;

@Component
@Singleton
public class DefaultWikiService
extends AbstractWikiService {
    @Inject
    private Execution execution;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    public Boolean isMultiWiki() {
        return this.getXWikiContext().getWiki().isVirtualMode();
    }

    public List<String> getVirtualWikiNames() {
        List<String> virtualWikiNamesList = new ArrayList();
        try {
            virtualWikiNamesList = this.getXWikiContext().getWiki().getVirtualWikisDatabaseNames(this.getXWikiContext());
            if (virtualWikiNamesList.size() == 0) {
                virtualWikiNamesList.add(this.getXWikiContext().getDatabase());
            }
            Collections.sort(virtualWikiNamesList);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return virtualWikiNamesList;
    }

    @Override
    protected String getCurrentUserRelativeTo(String wikiName) {
        return (String)this.compactEntityReferenceSerializer.serialize((EntityReference)this.getXWikiContext().getUserReference(), new Object[]{new WikiReference(wikiName)});
    }

    @Override
    protected List<WikiPage> getWikiPages(List<DocumentReference> documentReferences) {
        XWikiContext context = this.getXWikiContext();
        ArrayList<WikiPage> wikiPages = new ArrayList<WikiPage>();
        for (DocumentReference documentReference : documentReferences) {
            try {
                WikiPage wikiPage = new WikiPage();
                XWikiDocument document = context.getWiki().getDocument(documentReference, context);
                wikiPage.setReference(this.entityReferenceConverter.convert(documentReference).getEntityReference());
                wikiPage.setTitle(document.getRenderedTitle(Syntax.XHTML_1_0, context));
                wikiPage.setUrl(document.getURL("view", context));
                wikiPages.add(wikiPage);
            }
            catch (Exception e) {
                this.logger.warn("Failed to load document [{}]", (Object)documentReference, (Object)e);
            }
        }
        return wikiPages;
    }

    public List<Attachment> getAttachments(WikiPageReference reference) {
        try {
            XWikiContext context = this.getXWikiContext();
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            DocumentReference documentReference = this.entityReferenceConverter.convert(reference);
            XWikiDocument doc = context.getWiki().getDocument(documentReference, context);
            for (XWikiAttachment attach : doc.getAttachmentList()) {
                AttachmentReference attachmentReference = new AttachmentReference(attach.getFilename(), reference);
                Attachment currentAttach = new Attachment();
                currentAttach.setUrl(doc.getAttachmentURL(attach.getFilename(), context));
                currentAttach.setReference(attachmentReference.getEntityReference());
                currentAttach.setMimeType(attach.getMimeType(context));
                attachments.add(currentAttach);
            }
            return attachments;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException("Failed to retrieve the list of attachments.", e);
        }
    }
}

