/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.plugin.importer;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;

public class OfficeMacroImporter {
    private final RenderingContext renderingContext;
    private final Transformation macroTransformation;
    private final BlockRenderer xhtmlRenderer;
    private final EntityReferenceSerializer<String> entityReferenceSerializer;

    public OfficeMacroImporter(ComponentManager componentManager) {
        try {
            this.renderingContext = (RenderingContext)componentManager.getInstance(RenderingContext.class);
            this.macroTransformation = (Transformation)componentManager.getInstance(Transformation.class, "macro");
            this.xhtmlRenderer = (BlockRenderer)componentManager.getInstance(BlockRenderer.class, "annotatedxhtml/1.0");
            this.entityReferenceSerializer = (EntityReferenceSerializer)componentManager.getInstance((Type)EntityReferenceSerializer.TYPE_STRING);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to initialize the office importer based on office macro.", e);
        }
    }

    public XDOM buildXDOM(AttachmentReference attachmentReference, boolean filterStyles) {
        HashMap<String, String> macroParams = new HashMap<String, String>();
        macroParams.put("attachment", attachmentReference.getName());
        if (!filterStyles) {
            macroParams.put("filterStyles", "false");
        }
        MacroBlock officeMacro = new MacroBlock("office", macroParams, false);
        XDOM xdom = new XDOM(Collections.singletonList(officeMacro));
        xdom.getMetaData().addMetaData("base", this.entityReferenceSerializer.serialize((EntityReference)attachmentReference.getDocumentReference(), new Object[0]));
        return xdom;
    }

    public String render(XDOM xdom) throws Exception {
        TransformationContext txContext = new TransformationContext();
        txContext.setXDOM(xdom);
        ((MutableRenderingContext)this.renderingContext).transformInContext(this.macroTransformation, txContext, (Block)xdom);
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.xhtmlRenderer.render((Block)xdom, (WikiPrinter)printer);
        return printer.toString();
    }
}

