/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xar.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.xar.internal.XarObjectPropertySerializer;

@Component(roles={XarObjectPropertySerializerManager.class})
@Singleton
public class XarObjectPropertySerializerManager {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private XarObjectPropertySerializer defaultPropertySerializer;

    public XarObjectPropertySerializer getPropertySerializer(String type) throws ComponentLookupException {
        if (type != null) {
            ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
            if (componentManager.hasComponent(XarObjectPropertySerializer.class, type)) {
                return this.getInstance(type, componentManager);
            }
            String simpleType = StringUtils.removeEnd((String)StringUtils.substringAfterLast((String)type, (String)"."), (String)"Class");
            if (componentManager.hasComponent(XarObjectPropertySerializer.class, simpleType)) {
                return this.getInstance(simpleType, componentManager);
            }
        }
        return this.defaultPropertySerializer;
    }

    private XarObjectPropertySerializer getInstance(String type, ComponentManager componentManager) throws ComponentLookupException {
        return (XarObjectPropertySerializer)componentManager.getInstance(XarObjectPropertySerializer.class, type);
    }
}

