/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xar.internal.property;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xwiki.component.annotation.Component;
import org.xwiki.xar.internal.XarObjectPropertySerializer;

@Component(hints={"StaticList", "DBList", "DBTreeList", "Page"})
@Singleton
public class ListXarObjectPropertySerializer
implements XarObjectPropertySerializer {
    public static final String ELEMENT_VALUE = "value";

    @Override
    public Object read(XMLStreamReader reader) throws XMLStreamException {
        StringBuffer content = new StringBuffer();
        int eventType = reader.next();
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                content.append(reader.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content");
                }
                if (eventType == 1) {
                    return this.readList(reader);
                }
                throw new XMLStreamException("Unexpected event type " + eventType, reader.getLocation());
            }
            eventType = reader.next();
        }
        return content.toString();
    }

    private List<String> readList(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<String> list = new ArrayList<String>();
        while (reader.getEventType() == 1) {
            reader.require(1, null, ELEMENT_VALUE);
            list.add(reader.getElementText());
            reader.nextTag();
        }
        return list;
    }

    @Override
    public void write(XMLStreamWriter writer, Object value) throws XMLStreamException {
        if (value instanceof List) {
            List list = (List)value;
            for (String element : list) {
                if (value == null) continue;
                writer.writeStartElement(ELEMENT_VALUE);
                writer.writeCharacters(element);
                writer.writeEndElement();
            }
        } else {
            writer.writeCharacters(value.toString());
        }
    }
}

