/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xar;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.stability.Unstable;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarException;
import org.xwiki.xar.XarPackage;

@Unstable
public class XarFile
implements Closeable {
    private File file;
    private ZipFile zipFile;
    private XarPackage xarPackage;

    public XarFile(File file) throws XarException, IOException {
        this(file, (XarPackage)null);
    }

    public XarFile(File file, Collection<XarEntry> pages) throws XarException, IOException {
        this(file, pages != null ? new XarPackage(pages) : null);
    }

    public XarFile(File file, XarPackage xarPackage) throws XarException, IOException {
        this.file = file;
        this.zipFile = new ZipFile(file);
        this.xarPackage = xarPackage != null ? xarPackage : new XarPackage(this.zipFile);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    public InputStream getInputStream(LocalDocumentReference reference) throws IOException {
        XarEntry entry = this.xarPackage.getEntry(reference);
        if (entry == null) {
            throw new IOException("Failed to find entry for referenc [" + reference + "]");
        }
        return this.zipFile.getInputStream(this.zipFile.getEntry(entry.getEntryName()));
    }

    public Collection<XarEntry> getEntries() {
        return this.xarPackage.getEntries();
    }

    public XarEntry getEntry(LocalDocumentReference reference) {
        return this.xarPackage.getEntry(reference);
    }

    public String toString() {
        return this.file.toString();
    }
}

