/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xwiki.model.internal.reference.LocalStringEntityReferenceSerializer;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarException;
import org.xwiki.xar.internal.XarUtils;

public class XarPackage {
    private static final LocalStringEntityReferenceSerializer TOSTRING_SERIALIZER = new LocalStringEntityReferenceSerializer();
    private String packageExtensionId;
    private boolean packagePreserveVersion = true;
    private String packageName;
    private String packageDescription;
    private String packageLicense;
    private String packageAuthor;
    private String packageVersion;
    private boolean packageBackupPack;
    private final Map<LocalDocumentReference, XarEntry> entries = new LinkedHashMap<LocalDocumentReference, XarEntry>();

    public XarPackage() {
    }

    public XarPackage(ZipFile zipFile) throws XarException, IOException {
        this.read(zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XarPackage(File file) throws IOException, XarException {
        try (ZipFile zipFile = new ZipFile(file);){
            this.read(zipFile);
        }
    }

    public XarPackage(InputStream xarStream) throws IOException, XarException {
        this.read(xarStream);
    }

    public XarPackage(Collection<XarEntry> entries) {
        for (XarEntry entry : entries) {
            this.entries.put(entry, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream xarStream) throws IOException, XarException {
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream(xarStream, "UTF-8", false);){
            ZipArchiveEntry entry = zis.getNextZipEntry();
            while (entry != null) {
                if (!entry.isDirectory() && zis.canReadEntryData((ArchiveEntry)entry)) {
                    this.readEntry((InputStream)zis, entry);
                }
                entry = zis.getNextZipEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ZipFile zipFile) throws IOException, XarException {
        Enumeration zipEntries = zipFile.getEntries();
        while (zipEntries.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)zipEntries.nextElement();
            if (entry.isDirectory()) continue;
            try (InputStream stream = zipFile.getInputStream(entry);){
                this.readEntry(stream, entry);
            }
        }
    }

    private void readEntry(InputStream stream, ZipArchiveEntry entry) throws XarException, IOException {
        if (entry.getName().equals("package.xml")) {
            this.readDescriptor(stream);
        } else {
            XarEntry xarEntry = new XarEntry(XarUtils.getReference(stream), entry.getName());
            this.entries.put(xarEntry, xarEntry);
        }
    }

    public String getPackageExtensionId() {
        return this.packageExtensionId;
    }

    public void setPackageExtensionId(String packageExtensionId) {
        this.packageExtensionId = packageExtensionId;
    }

    public boolean isPackagePreserveVersion() {
        return this.packagePreserveVersion;
    }

    public void setPreserveVersion(boolean preserveVersion) {
        this.packagePreserveVersion = preserveVersion;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageDescription() {
        return this.packageDescription;
    }

    public void setPackageDescription(String packageDescription) {
        this.packageDescription = packageDescription;
    }

    public String getPackageLicense() {
        return this.packageLicense;
    }

    public void setPackageLicense(String packageLicense) {
        this.packageLicense = packageLicense;
    }

    public String getPackageAuthor() {
        return this.packageAuthor;
    }

    public void setPackageAuthor(String packageAuthor) {
        this.packageAuthor = packageAuthor;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public boolean isPackageBackupPack() {
        return this.packageBackupPack;
    }

    public void setPackageBackupPack(boolean packageBackupPack) {
        this.packageBackupPack = packageBackupPack;
    }

    public void addEntry(LocalDocumentReference reference) {
        this.entries.put(reference, new XarEntry(reference));
    }

    public Collection<XarEntry> getEntries() {
        return this.entries.values();
    }

    public static Collection<XarEntry> getEntries(File file) throws XarException, IOException {
        XarPackage xarPackage = new XarPackage(file);
        return xarPackage.getEntries();
    }

    public XarEntry getEntry(LocalDocumentReference reference) {
        return this.entries.get(reference);
    }

    public void readDescriptor(InputStream stream) throws XarException, IOException {
        Document doc;
        DocumentBuilder dBuilder;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XarException("Failed to create a new Document builder", e);
        }
        try {
            doc = dBuilder.parse((InputStream)new CloseShieldInputStream(stream));
        }
        catch (SAXException e) {
            throw new XarException("Failed to parse XML document", e);
        }
        doc.getDocumentElement().normalize();
        this.packageExtensionId = this.getElementText(doc, "extensionId");
        this.packageVersion = this.getElementText(doc, "version");
        this.packageName = this.getElementText(doc, "name");
        this.packageDescription = this.getElementText(doc, "description");
        this.packageLicense = this.getElementText(doc, "licence");
        this.packageAuthor = this.getElementText(doc, "author");
        this.packageBackupPack = Boolean.valueOf(this.getElementText(doc, "backupPack"));
        this.packagePreserveVersion = Boolean.valueOf(this.getElementText(doc, "preserveVersion"));
    }

    private String getElementText(Document doc, String tagName) {
        NodeList nList = doc.getElementsByTagName(tagName);
        return nList.getLength() > 0 ? nList.item(0).getTextContent() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ZipArchiveOutputStream zipStream, String encoding) throws XarException, IOException {
        ZipArchiveEntry zipentry = new ZipArchiveEntry("package.xml");
        zipStream.putArchiveEntry((ArchiveEntry)zipentry);
        try {
            this.write((OutputStream)zipStream, encoding);
        }
        finally {
            zipStream.closeArchiveEntry();
        }
    }

    public void write(OutputStream stream, String encoding) throws XarException, IOException {
        XMLStreamWriter writer;
        try {
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(stream, encoding);
        }
        catch (Exception e) {
            throw new XarException("Failed to create an instance of XML stream writer", e);
        }
        writer = new IndentingXMLStreamWriter(writer);
        try {
            this.writer(writer, encoding);
            writer.flush();
        }
        catch (Exception e) {
            throw new XarException("Failed to write XML", e);
        }
        finally {
            try {
                writer.close();
            }
            catch (XMLStreamException e) {
                throw new XarException("Failed to close XML writer", e);
            }
        }
    }

    private void writer(XMLStreamWriter writer, String encoding) throws XMLStreamException {
        writer.writeStartDocument(encoding, "1.0");
        writer.writeStartElement("package");
        writer.writeStartElement("infos");
        this.writeElement(writer, "name", this.getPackageName());
        this.writeElement(writer, "description", this.getPackageDescription());
        this.writeElement(writer, "licence", this.getPackageLicense());
        this.writeElement(writer, "author", this.getPackageAuthor());
        this.writeElement(writer, "version", this.getPackageVersion());
        this.writeElement(writer, "backupPack", String.valueOf(this.isPackageBackupPack()));
        this.writeElement(writer, "preserveVersion", String.valueOf(this.isPackagePreserveVersion()));
        this.writeElement(writer, "extensionId", this.getPackageExtensionId());
        writer.writeEndElement();
        writer.writeStartElement("files");
        for (XarEntry entry : this.entries.values()) {
            writer.writeStartElement("file");
            writer.writeAttribute("defaultAction", String.valueOf(entry.getDefaultAction()));
            writer.writeAttribute("language", Objects.toString(entry.getLocale(), ""));
            writer.writeCharacters(TOSTRING_SERIALIZER.serialize((EntityReference)entry, new Object[0]));
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private void writeElement(XMLStreamWriter streamWriter, String localName, String value) throws XMLStreamException {
        if (value != null) {
            if (value.isEmpty()) {
                streamWriter.writeEmptyElement(localName);
            } else {
                streamWriter.writeStartElement(localName);
                streamWriter.writeCharacters(value);
                streamWriter.writeEndElement();
            }
        } else {
            streamWriter.writeEmptyElement(localName);
        }
    }
}

