/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xar.script;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.script.service.ScriptService;
import org.xwiki.xar.XarPackage;

@Component
@Named(value="xar")
@Singleton
public class XarScriptService
implements ScriptService {
    public static final String ERROR_KEY = "scriptservice.xar.error";
    @Inject
    protected Execution execution;

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(ERROR_KEY);
    }

    protected void setError(Exception e) {
        this.execution.getContext().setProperty(ERROR_KEY, (Object)e);
    }

    public XarPackage getXarPackage(File file) {
        try {
            return new XarPackage(file);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XarPackage getXarPackage(InputStream stream, boolean close) {
        try {
            XarPackage xarPackage = new XarPackage(stream);
            return xarPackage;
        }
        catch (Exception e) {
            this.setError(e);
        }
        finally {
            if (close) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

