/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.IFrameElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.user.client.BackForwardCache;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.wysiwyg.client.PlainTextEditor;
import org.xwiki.gwt.wysiwyg.client.RichTextEditor;
import org.xwiki.gwt.wysiwyg.client.RichTextEditorController;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.WysiwygEditorTabSwitchHandler;
import org.xwiki.gwt.wysiwyg.client.plugin.PluginFactoryManager;
import org.xwiki.gwt.wysiwyg.client.syntax.SyntaxValidatorManager;

public class WysiwygEditor
extends RichTextEditorController {
    public static final String DEFAULT_SYNTAX = "xhtml/1.0";
    protected static final int WYSIWYG_TAB_INDEX = 0;
    protected static final int SOURCE_TAB_INDEX = 1;
    private Widget ui;

    public WysiwygEditor(Config config, SyntaxValidatorManager svm, PluginFactoryManager pfm) {
        super(new RichTextEditor(), config, pfm, svm.getSyntaxValidator(config.getParameter("syntax", DEFAULT_SYNTAX)));
        IFrameElement.as((Element)this.getRichTextEditor().getTextArea().getElement()).setSrc(config.getParameter("inputURL", "about:blank"));
        this.getRichTextEditor().getTextArea().setHeight(Math.max(this.getHook().getOffsetHeight(), 100) + "px");
        if (this.isTabbed()) {
            this.createTabPanel();
        } else {
            this.ui = this.getRichTextEditor();
        }
        this.getHook().getStyle().setDisplay(Style.Display.NONE);
    }

    protected void initTextArea() {
        int selectedTab = this.getSelectedTab();
        if (selectedTab != 1) {
            if (selectedTab == 0) {
                this.getPlainTextEditor().getTextArea().setEnabled(false);
            }
            super.initTextArea();
        }
    }

    private TabPanel createTabPanel() {
        org.xwiki.gwt.dom.client.Element cacheableElement = (org.xwiki.gwt.dom.client.Element)DOM.getElementById((String)this.getConfig().getParameter("cacheId", "")).cast();
        final BackForwardCache cache = new BackForwardCache(cacheableElement);
        PlainTextEditor plainTextEditor = new PlainTextEditor(this.getHook(), cache);
        TabPanel tabs = new TabPanel();
        this.ui = tabs;
        tabs.add((Widget)this.getRichTextEditor(), Strings.INSTANCE.wysiwyg());
        tabs.add((Widget)plainTextEditor, Strings.INSTANCE.source());
        tabs.setStyleName("xRichTextEditorTabPanel");
        tabs.setAnimationEnabled(false);
        String wysiwygTabName = "wysiwyg";
        String cacheKeyActiveTextArea = "editor.activeTextArea";
        String defaultEditor = cache.get("editor.activeTextArea", this.getConfig().getParameter("defaultEditor"));
        tabs.selectTab("wysiwyg".equals(defaultEditor) ? 0 : 1);
        plainTextEditor.getTextArea().setEnabled(true);
        this.getRichTextEditor().getTextArea().setEnabled(false);
        WysiwygEditorTabSwitchHandler editorSwitcher = new WysiwygEditorTabSwitchHandler(this);
        this.saveRegistration(tabs.addBeforeSelectionHandler((BeforeSelectionHandler)editorSwitcher));
        this.saveRegistration(tabs.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                cache.put("editor.activeTextArea", (Integer)event.getSelectedItem() == 0 ? "wysiwyg" : "source");
            }
        }));
        this.saveRegistration(tabs.addSelectionHandler((SelectionHandler)editorSwitcher));
        return tabs;
    }

    public Widget getUI() {
        return this.ui;
    }

    public PlainTextEditor getPlainTextEditor() {
        return this.isTabbed() ? (PlainTextEditor)((TabPanel)this.ui).getWidget(1) : null;
    }

    private org.xwiki.gwt.dom.client.Element getHook() {
        return (org.xwiki.gwt.dom.client.Element)DOM.getElementById((String)this.getConfig().getParameter("hookId")).cast();
    }

    private boolean isTabbed() {
        return Boolean.valueOf(this.getConfig().getParameter("displayTabs", "false"));
    }

    public int getSelectedTab() {
        return this.ui instanceof TabPanel ? ((TabPanel)this.ui).getTabBar().getSelectedTab() : -1;
    }

    public void setSelectedTab(int index) {
        if (this.ui instanceof TabPanel) {
            ((TabPanel)this.ui).selectTab(index);
        }
    }

    public void destroy() {
        super.destroy();
        this.ui.removeFromParent();
    }
}

