/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.diff;

import java.util.List;
import org.xwiki.gwt.wysiwyg.client.diff.AddDelta;
import org.xwiki.gwt.wysiwyg.client.diff.ChangeDelta;
import org.xwiki.gwt.wysiwyg.client.diff.Chunk;
import org.xwiki.gwt.wysiwyg.client.diff.DeleteDelta;
import org.xwiki.gwt.wysiwyg.client.diff.PatchFailedException;
import org.xwiki.gwt.wysiwyg.client.diff.RevisionVisitor;
import org.xwiki.gwt.wysiwyg.client.diff.ToString;

public abstract class Delta
extends ToString {
    protected Chunk original;
    protected Chunk revised;

    public static Delta newDelta(Chunk orig, Chunk rev) {
        Delta result;
        if (orig.size() > 0 && rev.size() > 0) {
            result = new ChangeDelta();
        } else if (orig.size() == 0 && rev.size() == 0) {
            result = new ChangeDelta();
        } else if (orig.size() > 0 && rev.size() == 0) {
            result = new DeleteDelta();
        } else if (orig.size() == 0 && rev.size() > 0) {
            result = new AddDelta();
        } else {
            return null;
        }
        result.init(orig, rev);
        return result;
    }

    public Delta() {
    }

    public Delta(Chunk orig, Chunk rev) {
        this.init(orig, rev);
    }

    public void init(Chunk orig, Chunk rev) {
        this.original = orig;
        this.revised = rev;
    }

    public abstract void verify(List var1) throws PatchFailedException;

    public final void patch(List target) throws PatchFailedException {
        this.verify(target);
        try {
            this.applyTo(target);
        }
        catch (Exception e) {
            throw new PatchFailedException(e.getMessage());
        }
    }

    public abstract void applyTo(List var1);

    public void toString(StringBuffer s) {
        this.original.rangeString(s);
        s.append("x");
        this.revised.rangeString(s);
        s.append(" ");
        this.original.toString(s, "> ", "\n");
        s.append("---");
        s.append(" ");
        this.revised.toString(s, "< ", "\n");
    }

    public abstract void toRCSString(StringBuffer var1, String var2);

    public String toRCSString(String EOL) {
        StringBuffer s = new StringBuffer();
        this.toRCSString(s, EOL);
        return s.toString();
    }

    public Chunk getOriginal() {
        return this.original;
    }

    public Chunk getRevised() {
        return this.revised;
    }

    public abstract void accept(RevisionVisitor var1);
}

