/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.UIObject;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.InnerHTMLListener;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardListener;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageBehaviorAdjuster;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigJSONParser;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigJSONSerializer;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageMenuExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageMetaDataExtractor;
import org.xwiki.gwt.wysiwyg.client.plugin.image.exec.InsertImageExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.ImageWizard;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class ImagePlugin
extends AbstractPlugin
implements ClickHandler,
WizardListener {
    private PushButton imageButton;
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");
    private ImageMenuExtension menuExtension;
    private ImageMetaDataExtractor metaDataExtractor;
    private ImageBehaviorAdjuster behaviorAdjuster;
    private ImageWizard imageWizard;
    private final WikiServiceAsync wikiService;
    private final ImageConfigJSONSerializer imageConfigJSONSerializer = new ImageConfigJSONSerializer();
    private final ImageConfigJSONParser imageConfigJSONParser = new ImageConfigJSONParser();

    public ImagePlugin(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
    }

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        textArea.getCommandManager().registerCommand(Command.INSERT_IMAGE, (Executable)new InsertImageExecutable(textArea));
        if (this.getTextArea().getCommandManager().isSupported(Command.INSERT_IMAGE)) {
            this.imageButton = new PushButton(new Image(Images.INSTANCE.image()));
            this.saveRegistration(this.imageButton.addClickHandler((ClickHandler)this));
            this.imageButton.setTitle(Strings.INSTANCE.imageTooltip());
            this.toolBarExtension.addFeature("image", (UIObject)this.imageButton);
            this.getUIExtensionList().add(this.toolBarExtension);
            this.menuExtension = new ImageMenuExtension(this);
            this.getUIExtensionList().add(this.menuExtension);
            this.imageWizard = new ImageWizard(this.getConfig(), this.wikiService);
            this.imageWizard.addWizardListener(this);
        }
        this.metaDataExtractor = new ImageMetaDataExtractor();
        this.metaDataExtractor.onInnerHTMLChange((Element)this.getTextArea().getDocument().getDocumentElement());
        this.getTextArea().getDocument().addInnerHTMLListener((InnerHTMLListener)this.metaDataExtractor);
        this.behaviorAdjuster = new ImageBehaviorAdjuster();
        this.behaviorAdjuster.setTextArea(this.getTextArea());
        this.saveRegistration(this.getTextArea().addKeyDownHandler((KeyDownHandler)this.behaviorAdjuster));
        this.saveRegistration(this.getTextArea().addKeyUpHandler((KeyUpHandler)this.behaviorAdjuster));
        this.saveRegistration(this.getTextArea().addKeyPressHandler((KeyPressHandler)this.behaviorAdjuster));
    }

    public void destroy() {
        if (this.imageButton != null) {
            this.imageButton.removeFromParent();
            this.imageButton = null;
        }
        this.toolBarExtension.clearFeatures();
        if (this.menuExtension != null) {
            this.menuExtension.destroy();
        }
        if (this.metaDataExtractor != null) {
            this.getTextArea().getDocument().removeInnerHTMLListener((InnerHTMLListener)this.metaDataExtractor);
            this.metaDataExtractor = null;
        }
        this.behaviorAdjuster = null;
        super.destroy();
    }

    public void onClick(ClickEvent event) {
        if (event.getSource() == this.imageButton) {
            this.onImage();
        }
    }

    public void onImage() {
        ImageConfig config;
        String imageParam = this.getTextArea().getCommandManager().getStringValue(Command.INSERT_IMAGE);
        if (imageParam != null) {
            config = this.imageConfigJSONParser.parse(imageParam);
        } else {
            config = new ImageConfig();
            config.setAltText(this.getTextArea().getDocument().getSelection().getRangeAt(0).toString());
        }
        this.imageWizard.start(ImageWizard.ImageWizardSteps.IMAGE_SELECTOR.toString(), config);
    }

    public void onImageRemove() {
        if (this.getTextArea().getCommandManager().isExecuted(Command.INSERT_IMAGE)) {
            this.getTextArea().setFocus(true);
            this.getTextArea().getCommandManager().execute(Command.DELETE);
        }
    }

    public void onFinish(Wizard sender, Object result) {
        this.getTextArea().setFocus(true);
        String imageJSON = this.imageConfigJSONSerializer.serialize((ImageConfig)result);
        this.getTextArea().getCommandManager().execute(Command.INSERT_IMAGE, imageJSON);
    }

    public void onCancel(Wizard sender) {
        this.getTextArea().setFocus(true);
    }
}

