/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import com.google.gwt.dom.client.Node;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.InnerHTMLListener;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardListener;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigJSONParser;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.link.EmptyLinkFilter;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkHTMLGenerator;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkMenuExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkMetaDataExtractor;
import org.xwiki.gwt.wysiwyg.client.plugin.link.exec.CreateLinkExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.link.exec.LinkExecutableUtils;
import org.xwiki.gwt.wysiwyg.client.plugin.link.exec.UnlinkExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizard;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceName;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class LinkPlugin
extends AbstractPlugin
implements WizardListener {
    private Wizard linkWizard;
    private LinkMenuExtension menuExtension;
    private LinkMetaDataExtractor metaDataExtractor;
    private EmptyLinkFilter linkFilter;
    private Map<Command, Executable> originalExecutables;
    private final WikiServiceAsync wikiService;
    private final ImageConfigJSONParser imageConfigJSONParser = new ImageConfigJSONParser();

    public LinkPlugin(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
    }

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        Executable createLinkExec = this.getTextArea().getCommandManager().registerCommand(Command.CREATE_LINK, (Executable)new CreateLinkExecutable(textArea));
        Executable unlinkExec = this.getTextArea().getCommandManager().registerCommand(Command.UNLINK, (Executable)new UnlinkExecutable(textArea));
        if (createLinkExec != null || unlinkExec != null) {
            this.originalExecutables = new HashMap<Command, Executable>();
        }
        if (createLinkExec != null) {
            this.originalExecutables.put(Command.CREATE_LINK, createLinkExec);
        }
        if (unlinkExec != null) {
            this.originalExecutables.put(Command.UNLINK, unlinkExec);
        }
        this.menuExtension = new LinkMenuExtension(this);
        this.getUIExtensionList().add(this.menuExtension);
        this.metaDataExtractor = new LinkMetaDataExtractor();
        this.metaDataExtractor.onInnerHTMLChange((Element)this.getTextArea().getDocument().getDocumentElement());
        this.getTextArea().getDocument().addInnerHTMLListener((InnerHTMLListener)this.metaDataExtractor);
        this.linkFilter = new EmptyLinkFilter(this.getTextArea());
        this.getTextArea().getCommandManager().addCommandListener((CommandListener)this.linkFilter);
    }

    public void destroy() {
        if (this.originalExecutables != null) {
            for (Map.Entry<Command, Executable> entry : this.originalExecutables.entrySet()) {
                this.getTextArea().getCommandManager().registerCommand(entry.getKey(), entry.getValue());
            }
        }
        if (this.metaDataExtractor != null) {
            this.getTextArea().getDocument().removeInnerHTMLListener((InnerHTMLListener)this.metaDataExtractor);
            this.metaDataExtractor = null;
        }
        this.getTextArea().getCommandManager().removeCommandListener((CommandListener)this.linkFilter);
        this.menuExtension.destroy();
        super.destroy();
    }

    public void onLinkInsert(LinkConfig.LinkType linkType) {
        LinkConfig linkParams = this.getLinkParams();
        linkParams.setType(linkType);
        this.dispatchLinkWizard(linkParams);
    }

    public void onLinkEdit() {
        LinkConfig editParams = this.getLinkParams();
        this.dispatchLinkWizard(editParams);
    }

    protected void dispatchLinkWizard(LinkConfig linkParams) {
        switch (linkParams.getType()) {
            case WIKIPAGE: 
            case NEW_WIKIPAGE: {
                this.getLinkWizard().start(LinkWizard.LinkWizardSteps.WIKI_PAGE.toString(), (Object)linkParams);
                break;
            }
            case ATTACHMENT: {
                this.getLinkWizard().start(LinkWizard.LinkWizardSteps.ATTACHMENT.toString(), (Object)linkParams);
                break;
            }
            case EMAIL: {
                this.getLinkWizard().start(LinkWizard.LinkWizardSteps.EMAIL.toString(), (Object)linkParams);
                break;
            }
            default: {
                this.getLinkWizard().start(LinkWizard.LinkWizardSteps.WEB_PAGE.toString(), (Object)linkParams);
            }
        }
    }

    private Wizard getLinkWizard() {
        if (this.linkWizard == null) {
            this.linkWizard = new LinkWizard(this.getConfig(), this.wikiService);
            this.linkWizard.addWizardListener((WizardListener)this);
        }
        return this.linkWizard;
    }

    protected LinkConfig getLinkParams() {
        String configString = this.getTextArea().getCommandManager().getStringValue(Command.CREATE_LINK);
        if (configString != null) {
            return this.getEditLinkParams(configString);
        }
        return this.getCreateLinkParams();
    }

    protected LinkConfig getEditLinkParams(String linkCommandParameter) {
        LinkConfig linkParam = new LinkConfig();
        linkParam.fromJSON(linkCommandParameter);
        Range range = this.getTextArea().getDocument().getSelection().getRangeAt(0);
        Element wrappingAnchor = LinkExecutableUtils.getSelectedAnchor(this.getTextArea());
        if (wrappingAnchor.getChildNodes().getLength() == 1 && wrappingAnchor.getChildNodes().getItem(0).getNodeName().equalsIgnoreCase("img")) {
            Range imageRange = this.getTextArea().getDocument().createRange();
            imageRange.selectNode(wrappingAnchor.getChildNodes().getItem(0));
            this.getTextArea().getDocument().getSelection().removeAllRanges();
            this.getTextArea().getDocument().getSelection().addRange(imageRange);
            String imageParam = this.getTextArea().getCommandManager().getStringValue(Command.INSERT_IMAGE);
            if (imageParam != null) {
                this.parseLabelFromImage(linkParam, imageParam);
            } else {
                linkParam.setLabelText(wrappingAnchor.getInnerText());
            }
        }
        range.selectNode((Node)wrappingAnchor);
        this.getTextArea().getDocument().getSelection().removeAllRanges();
        this.getTextArea().getDocument().getSelection().addRange(range);
        return linkParam;
    }

    protected LinkConfig getCreateLinkParams() {
        LinkConfig config = new LinkConfig();
        config.setLabel(this.getTextArea().getDocument().getSelection().getRangeAt(0).toHTML());
        String imageParam = this.getTextArea().getCommandManager().getStringValue(Command.INSERT_IMAGE);
        if (imageParam != null) {
            this.parseLabelFromImage(config, imageParam);
        } else {
            config.setLabelText(this.getTextArea().getDocument().getSelection().getRangeAt(0).toString());
            config.setReadOnlyLabel(false);
        }
        return config;
    }

    protected void parseLabelFromImage(LinkConfig linkConfig, String imageJSON) {
        ResourceName imageResource = new ResourceName(this.imageConfigJSONParser.parse(imageJSON).getReference(), true);
        linkConfig.setLabelText(imageResource.getFile());
        linkConfig.setReadOnlyLabel(true);
    }

    public void onUnlink() {
        this.getTextArea().setFocus(true);
        this.getTextArea().getCommandManager().execute(Command.UNLINK);
    }

    public void onFinish(Wizard sender, Object result) {
        String linkHTML = LinkHTMLGenerator.getInstance().getLinkHTML((LinkConfig)result);
        this.getTextArea().setFocus(true);
        this.getTextArea().getCommandManager().execute(Command.CREATE_LINK, linkHTML);
    }

    public void onCancel(Wizard sender) {
        this.getTextArea().setFocus(true);
    }
}

