/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.ListItem;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.AbstractPageListSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceName;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPage;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchSelectorWizardStep
extends AbstractPageListSelectorWizardStep
implements ClickHandler,
KeyPressHandler {
    private static final String STYLE_LOADING = "loading";
    private static final String STYLE_ERROR = "errormessage";
    private String keyword;
    private TextBox searchBox;
    private WikiServiceAsync wikiService;

    public SearchSelectorWizardStep(ResourceName editedResource) {
        super(editedResource);
        this.getMainPanel().addStyleName("xPagesSearch");
        FlowPanel searchPanel = new FlowPanel();
        searchPanel.addStyleName("xSearchForm");
        this.searchBox = new TextBox();
        this.searchBox.setTitle(Strings.INSTANCE.linkWikipageSearchTooltip());
        Button searchButton = new Button(Strings.INSTANCE.linkWikipageSearchButton());
        searchButton.addClickHandler((ClickHandler)this);
        this.searchBox.addKeyPressHandler((KeyPressHandler)this);
        searchPanel.add((Widget)this.searchBox);
        searchPanel.add((Widget)searchButton);
        this.getMainPanel().insert((Widget)searchPanel, 0);
    }

    public void onClick(ClickEvent event) {
        this.keyword = this.searchBox.getText().trim();
        this.getMainPanel().addStyleName(STYLE_LOADING);
        this.refreshList(new AsyncCallback<Object>(){

            public void onSuccess(Object result) {
                SearchSelectorWizardStep.this.getMainPanel().removeStyleName(SearchSelectorWizardStep.STYLE_LOADING);
            }

            public void onFailure(Throwable caught) {
                SearchSelectorWizardStep.this.getMainPanel().removeStyleName(SearchSelectorWizardStep.STYLE_LOADING);
                Label error = new Label(Strings.INSTANCE.linkErrorLoadingData());
                error.addStyleName(SearchSelectorWizardStep.STYLE_ERROR);
                ListItem errorListItem = new ListItem();
                errorListItem.add((Widget)error);
                SearchSelectorWizardStep.this.getList().insertItem(errorListItem, 0);
            }
        });
    }

    @Override
    protected void fetchData(AsyncCallback<List<WikiPage>> callback) {
        this.wikiService.getMatchingPages(this.getKeyword(), 0, 20, callback);
    }

    public String getKeyword() {
        return this.keyword == null ? "" : this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void onKeyPress(KeyPressEvent event) {
        if (event.getSource() == this.searchBox && event.getNativeEvent().getKeyCode() == 13 && !event.isAnyModifierKeyDown()) {
            this.onClick(null);
        }
    }

    @Override
    public void setActive() {
        if (StringUtils.isEmpty((String)this.getKeyword())) {
            this.searchBox.setFocus(true);
        } else {
            super.setActive();
        }
    }

    public void setWikiService(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
    }
}

