/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import java.util.HashMap;
import java.util.Map;

public class MacroCall {
    private static final String START_MACRO = "startmacro:";
    private static final String SEPARATOR = "|-|";
    private String name;
    private final Map<String, String> argumentValues = new HashMap<String, String>();
    private final Map<String, String> argumentNames = new HashMap<String, String>();
    private String content;

    public MacroCall() {
    }

    public MacroCall(String startMacroComment) {
        String text = this.unescape(startMacroComment);
        int start = START_MACRO.length();
        int end = text.indexOf(SEPARATOR, start);
        this.name = text.substring(start, end);
        start = end + SEPARATOR.length();
        int equalIndex = text.indexOf(61, start);
        int separatorIndex = text.indexOf(SEPARATOR, start);
        while (equalIndex > 0 && (separatorIndex < 0 || equalIndex < separatorIndex)) {
            String argumentName = text.substring(start, equalIndex).trim();
            end = start = text.indexOf(34, equalIndex + 1) + 1;
            boolean escaped = false;
            while (escaped || text.charAt(end) != '\"') {
                escaped = !escaped && '\\' == text.charAt(end);
                ++end;
            }
            this.setArgument(argumentName, this.unescape(text.substring(start, end)));
            start = end + 1;
            equalIndex = text.indexOf(61, start);
            separatorIndex = text.indexOf(SEPARATOR, start);
        }
        if (separatorIndex >= 0) {
            this.content = text.substring(separatorIndex + SEPARATOR.length());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getArgument(String name) {
        return this.argumentValues.get(name.toLowerCase());
    }

    public String setArgument(String name, String value) {
        String id = name.toLowerCase();
        if (!id.equals(name) && !this.argumentNames.containsKey(id)) {
            this.argumentNames.put(id, name);
        }
        return this.argumentValues.put(id, value);
    }

    public String removeArgument(String name) {
        String id = name.toLowerCase();
        this.argumentNames.remove(id);
        return this.argumentValues.remove(id);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        StringBuffer strBuff = new StringBuffer(START_MACRO);
        strBuff.append(this.getName());
        strBuff.append(SEPARATOR);
        for (Map.Entry<String, String> entry : this.argumentValues.entrySet()) {
            String argumentName = this.argumentNames.get(entry.getKey());
            if (argumentName == null) {
                argumentName = entry.getKey();
            }
            strBuff.append(argumentName);
            strBuff.append("=\"");
            strBuff.append(this.escapeMacroParameterValue(entry.getValue()));
            strBuff.append("\" ");
        }
        if (this.content != null) {
            strBuff.append(SEPARATOR);
            strBuff.append(this.content);
        }
        return this.escapeComment(strBuff.toString());
    }

    private String escapeMacroParameterValue(String value) {
        return value.replaceAll("([\\\\\\\"])", "\\\\$1");
    }

    private String unescape(String text) {
        StringBuffer result = new StringBuffer();
        boolean escaped = false;
        for (char c : text.toCharArray()) {
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            result.append(c);
            escaped = false;
        }
        return result.toString();
    }

    private String escapeComment(String text) {
        StringBuffer result = new StringBuffer();
        int lastChar = 0;
        for (int n : text.toCharArray()) {
            if (n == 92) {
                result.append('\\');
            } else if (n == 45 && lastChar == 45) {
                result.append('\\');
            }
            result.append((char)n);
            lastChar = n;
        }
        if (lastChar == 45) {
            result.append('\\');
        }
        return result.toString();
    }
}

