/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDisplayer;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroMenuExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroSelector;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroServiceAsync;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroWizard;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.exec.CollapseExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.exec.InsertExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.exec.RefreshExecutable;

public class MacroPlugin
extends AbstractPlugin
implements DoubleClickHandler {
    public static final Command REFRESH = new Command("macroRefresh");
    public static final Command COLLAPSE = new Command("macroCollapseAll");
    public static final Command EXPAND = new Command("macroExpandAll");
    public static final Command INSERT = new Command("macroInsert");
    private MacroDisplayer displayer;
    private MacroSelector selector;
    private MacroWizard wizard;
    private MacroMenuExtension menuExtension;
    private final MacroServiceAsync macroService;

    public MacroPlugin(MacroServiceAsync macroService) {
        this.macroService = macroService;
    }

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.displayer = (MacroDisplayer)GWT.create(MacroDisplayer.class);
        this.displayer.setTextArea(this.getTextArea());
        this.selector = new MacroSelector(this.displayer);
        this.wizard = new MacroWizard(this.displayer, config, this.macroService);
        this.getTextArea().getCommandManager().registerCommand(REFRESH, (Executable)new RefreshExecutable(textArea));
        this.getTextArea().getCommandManager().registerCommand(COLLAPSE, (Executable)new CollapseExecutable(this.selector, true));
        this.getTextArea().getCommandManager().registerCommand(EXPAND, (Executable)new CollapseExecutable(this.selector, false));
        this.getTextArea().getCommandManager().registerCommand(INSERT, (Executable)new InsertExecutable(this.selector));
        this.saveRegistration(this.getTextArea().addDoubleClickHandler((DoubleClickHandler)this));
        this.menuExtension = new MacroMenuExtension(this);
        this.getUIExtensionList().add(this.menuExtension.getExtension());
    }

    public void destroy() {
        this.menuExtension.destroy();
        this.getTextArea().getCommandManager().unregisterCommand(REFRESH);
        this.getTextArea().getCommandManager().unregisterCommand(COLLAPSE);
        this.getTextArea().getCommandManager().unregisterCommand(EXPAND);
        this.getTextArea().getCommandManager().unregisterCommand(INSERT);
        this.selector.destroy();
        this.selector = null;
        this.displayer.destroy();
        this.displayer = null;
        this.wizard.destroy();
        this.wizard = null;
        super.destroy();
    }

    public MacroSelector getSelector() {
        return this.selector;
    }

    public void edit() {
        this.wizard.edit();
    }

    public void insert() {
        this.wizard.insert();
    }

    public void onDoubleClick(DoubleClickEvent event) {
        if (event.getSource() == this.getTextArea() && this.getSelector().getMacroCount() == 1) {
            this.edit();
        }
    }
}

