/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.TabPanel;
import java.util.HashMap;
import org.xwiki.gwt.user.client.ActionEvent;
import org.xwiki.gwt.user.client.CancelableAsyncCallback;
import org.xwiki.gwt.user.client.Console;
import org.xwiki.gwt.user.client.HasActionHandlers;
import org.xwiki.gwt.user.client.ui.rta.Reloader;
import org.xwiki.gwt.user.client.ui.rta.SelectionPreserver;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.wysiwyg.client.WysiwygEditor;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverter;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverterAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WysiwygEditorTabSwitchHandler
implements SelectionHandler<Integer>,
BeforeSelectionHandler<Integer> {
    private static final Command SUBMIT = new Command("submit");
    private static final Command ENABLE = new Command("enable");
    private static final Command RESET = new Command("reset");
    private final WysiwygEditor editor;
    private final HTMLConverterAsync converter = (HTMLConverterAsync)GWT.create(HTMLConverter.class);
    private final Reloader reloader;
    private final String sourceSyntax;
    private CancelableAsyncCallback<String> sourceCallback;
    private String lastConvertedHTML;
    private String lastConvertedSourceText;
    private SelectionPreserver domSelectionPreserver;
    private int[] sourceRange = new int[2];

    WysiwygEditorTabSwitchHandler(final WysiwygEditor editor) {
        HandlerRegistration[] registrations;
        this.editor = editor;
        this.reloader = new Reloader(editor.getRichTextEditor().getTextArea());
        this.sourceSyntax = editor.getConfig().getParameter("syntax", "xhtml/1.0");
        this.domSelectionPreserver = new SelectionPreserver(editor.getRichTextEditor().getTextArea());
        this.lastConvertedSourceText = editor.getPlainTextEditor().getTextArea().getText();
        registrations = new HandlerRegistration[]{editor.getRichTextEditor().getTextArea().addLoadHandler(new LoadHandler(){

            public void onLoad(LoadEvent event) {
                registrations[0].removeHandler();
                if (editor.getSelectedTab() == 0) {
                    WysiwygEditorTabSwitchHandler.this.lastConvertedHTML = editor.getRichTextEditor().getTextArea().getCommandManager().getStringValue(SUBMIT);
                }
            }
        })};
    }

    public void onBeforeSelection(BeforeSelectionEvent<Integer> event) {
        int currentlySelectedTab = ((TabPanel)event.getSource()).getTabBar().getSelectedTab();
        if ((Integer)event.getItem() == currentlySelectedTab) {
            event.cancel();
            return;
        }
        switch (currentlySelectedTab) {
            case 0: {
                if (this.editor.getRichTextEditor().isLoading()) break;
                this.editor.getRichTextEditor().getTextArea().getCommandManager().execute(SUBMIT);
                this.domSelectionPreserver.saveSelection();
                break;
            }
            case 1: {
                if (this.editor.getPlainTextEditor().isLoading()) break;
                this.sourceRange[0] = this.editor.getPlainTextEditor().getTextArea().getCursorPos();
                this.sourceRange[1] = this.editor.getPlainTextEditor().getTextArea().getSelectionLength();
                break;
            }
        }
        String[] actionNames = new String[]{"showingWysiwyg", "showingSource"};
        ActionEvent.fire((HasActionHandlers)this.editor.getRichTextEditor().getTextArea(), (String)actionNames[(Integer)event.getItem()]);
    }

    public void onSelection(SelectionEvent<Integer> event) {
        if ((Integer)event.getSelectedItem() == 0) {
            this.switchToWysiwyg();
        } else {
            this.switchToSource();
        }
    }

    private void switchToSource() {
        if (this.editor.getRichTextEditor().isLoading()) {
            this.restoreSourceSelection();
        } else {
            String currentHTML = this.editor.getRichTextEditor().getTextArea().getCommandManager().getStringValue(SUBMIT);
            if (!currentHTML.equals(this.lastConvertedHTML)) {
                this.lastConvertedHTML = currentHTML;
                this.sourceRange[0] = 0;
                this.sourceRange[1] = 0;
                if (this.sourceCallback != null) {
                    this.sourceCallback.setCanceled(true);
                } else {
                    this.editor.getPlainTextEditor().setLoading(true);
                }
                this.sourceCallback = new CancelableAsyncCallback((AsyncCallback)new AsyncCallback<String>(){

                    public void onFailure(Throwable caught) {
                        WysiwygEditorTabSwitchHandler.this.sourceCallback = null;
                        WysiwygEditorTabSwitchHandler.this.onSwitchToSourceFailure(caught);
                    }

                    public void onSuccess(String result) {
                        WysiwygEditorTabSwitchHandler.this.sourceCallback = null;
                        WysiwygEditorTabSwitchHandler.this.onSwitchToSourceSuccess(result);
                    }
                });
                this.converter.fromHTML(currentHTML, this.sourceSyntax, (AsyncCallback<String>)this.sourceCallback);
            } else if (!this.editor.getPlainTextEditor().isLoading()) {
                this.enableSourceTab();
            }
        }
    }

    private void onSwitchToSourceFailure(Throwable caught) {
        Console.getInstance().error((Object)caught.getLocalizedMessage(), new Object[0]);
        this.lastConvertedHTML = null;
        this.editor.setSelectedTab(0);
    }

    private void onSwitchToSourceSuccess(String source) {
        this.lastConvertedSourceText = source;
        this.editor.getPlainTextEditor().getTextArea().setText(source);
        this.editor.getPlainTextEditor().setLoading(false);
        if (this.editor.getSelectedTab() == 1) {
            this.enableSourceTab();
        }
    }

    private void enableSourceTab() {
        this.editor.getRichTextEditor().getTextArea().getCommandManager().execute(ENABLE, false);
        this.editor.getPlainTextEditor().getTextArea().setEnabled(true);
        this.editor.getPlainTextEditor().submit();
        this.restoreSourceSelection();
    }

    private void restoreSourceSelection() {
        this.editor.getPlainTextEditor().getTextArea().setFocus(true);
        this.editor.getPlainTextEditor().getTextArea().setSelectionRange(this.sourceRange[0], this.sourceRange[1]);
        ActionEvent.fire((HasActionHandlers)this.editor.getRichTextEditor().getTextArea(), (String)"showSource");
    }

    private void switchToWysiwyg() {
        if (this.editor.getPlainTextEditor().isLoading()) {
            DeferredCommand.addCommand((com.google.gwt.user.client.Command)new com.google.gwt.user.client.Command(){

                public void execute() {
                    WysiwygEditorTabSwitchHandler.this.restoreDOMSelection();
                }
            });
        } else {
            String currentSourceText = this.editor.getPlainTextEditor().getTextArea().getText();
            if (!currentSourceText.equals(this.lastConvertedSourceText)) {
                this.lastConvertedSourceText = currentSourceText;
                this.domSelectionPreserver.clearPlaceHolders();
                this.editor.getRichTextEditor().setLoading(true);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("source", currentSourceText);
                this.reloader.reload(params, (AsyncCallback)new AsyncCallback<String>(){

                    public void onFailure(Throwable caught) {
                        WysiwygEditorTabSwitchHandler.this.onSwitchToWysiwygFailure(caught);
                    }

                    public void onSuccess(String result) {
                        WysiwygEditorTabSwitchHandler.this.onSwitchToWysiwygSuccess();
                    }
                });
            } else if (!this.editor.getRichTextEditor().isLoading()) {
                DeferredCommand.addCommand((com.google.gwt.user.client.Command)new com.google.gwt.user.client.Command(){

                    public void execute() {
                        if (WysiwygEditorTabSwitchHandler.this.editor.getSelectedTab() == 0 && !WysiwygEditorTabSwitchHandler.this.editor.getRichTextEditor().isLoading()) {
                            WysiwygEditorTabSwitchHandler.this.enableWysiwygTab();
                        }
                    }
                });
            }
        }
    }

    private void onSwitchToWysiwygFailure(Throwable caught) {
        Console.getInstance().error((Object)caught.getLocalizedMessage(), new Object[0]);
        this.lastConvertedSourceText = null;
        this.editor.setSelectedTab(1);
    }

    private void onSwitchToWysiwygSuccess() {
        this.editor.getRichTextEditor().getTextArea().getCommandManager().execute(RESET);
        if (this.editor.getSelectedTab() == 0) {
            this.enableWysiwygTab();
        }
    }

    private void enableWysiwygTab() {
        this.editor.getPlainTextEditor().getTextArea().setEnabled(false);
        this.restoreDOMSelection();
        this.editor.getRichTextEditor().getTextArea().getCommandManager().execute(SUBMIT, true);
        this.lastConvertedHTML = this.editor.getRichTextEditor().getTextArea().getCommandManager().getStringValue(SUBMIT);
        this.editor.getRichTextEditor().getTextArea().getCommandManager().execute(ENABLE, true);
    }

    private void restoreDOMSelection() {
        this.editor.getRichTextEditor().getTextArea().setFocus(true);
        this.domSelectionPreserver.restoreSelection();
        ActionEvent.fire((HasActionHandlers)this.editor.getRichTextEditor().getTextArea(), (String)"showWysiwyg");
    }
}

