/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.smartgwt.client.widgets.events.KeyPressEvent;
import com.smartgwt.client.widgets.events.KeyPressHandler;
import com.smartgwt.client.widgets.grid.events.RecordDoubleClickEvent;
import com.smartgwt.client.widgets.grid.events.RecordDoubleClickHandler;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.VerticalResizePanel;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.widget.explorer.XWikiExplorer;
import org.xwiki.gwt.wysiwyg.client.widget.explorer.ds.WikiDataSource;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExplorerWizardStep
extends AbstractSelectorWizardStep<EntityLink<LinkConfig>>
implements SourcesNavigationEvents,
RecordDoubleClickHandler,
KeyPressHandler {
    protected static final String FIELD_ERROR_STYLE = "xErrorField";
    private final XWikiExplorer explorer = new XWikiExplorer();
    private final VerticalResizePanel mainPanel = new VerticalResizePanel();
    private final Label errorLabel = new Label();
    private final Label helpLabel = new Label();
    private final NavigationListenerCollection listeners = new NavigationListenerCollection();
    private final WikiServiceAsync wikiService;
    private String stepTitle;

    public AbstractExplorerWizardStep(WikiServiceAsync wikiService, boolean addPage, boolean showAttachments, boolean addAttachments) {
        this(wikiService, addPage, showAttachments, addAttachments, 455, 305);
    }

    protected AbstractExplorerWizardStep(WikiServiceAsync wikiService, boolean addPage, boolean showAttachments, boolean addAttachments, int width, int height) {
        this.wikiService = wikiService;
        this.explorer.setDisplayLinks(false);
        this.explorer.setDisplayAddPage(addPage);
        this.explorer.setDisplayAddPageOnTop(true);
        this.explorer.setDisplayAttachments(showAttachments);
        this.explorer.setDisplayAddAttachment(showAttachments && addAttachments);
        this.explorer.setDisplayAddAttachmentOnTop(true);
        this.explorer.setDisplayAttachmentsWhenEmpty(showAttachments && addAttachments);
        String sizeUnit = "px";
        this.explorer.setWidth(width + sizeUnit);
        this.explorer.setHeight(height + sizeUnit);
        WikiDataSource ds = new WikiDataSource();
        this.explorer.setDataSource(ds);
        this.explorer.setDefaultValue("");
        this.explorer.getElement().setClassName(this.explorer.getElement().getClassName() + " xExplorer");
        this.explorer.addRecordDoubleClickHandler(this);
        this.explorer.addKeyPressHandler(this);
        this.helpLabel.addStyleName("xHelpLabel");
        this.mainPanel.add((Widget)this.helpLabel);
        this.errorLabel.setVisible(false);
        this.errorLabel.addStyleName("xErrorMsg");
        this.mainPanel.add((Widget)this.errorLabel);
        this.mainPanel.addStyleName("xExplorerPanel");
        this.mainPanel.add((Widget)this.explorer);
        this.mainPanel.setExpandingWidget((Widget)this.explorer, true);
    }

    public void setHelpLabelText(String helpLabelText) {
        this.helpLabel.setText(helpLabelText);
    }

    protected void invalidateExplorerData() {
        try {
            this.explorer.invalidateCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Widget display() {
        return this.mainPanel;
    }

    public XWikiExplorer getExplorer() {
        return this.explorer;
    }

    @Override
    public void init(Object data, AsyncCallback<?> cb) {
        this.hideError();
        super.init(data, cb);
    }

    @Override
    protected void initializeSelection(AsyncCallback<?> initCallback) {
        String reference = ((LinkConfig)((EntityLink)this.getData()).getData()).getReference();
        if (!StringUtils.isEmpty((String)reference)) {
            this.getExplorer().selectEntity(((EntityLink)this.getData()).getDestination(), null);
        } else if (StringUtils.isEmpty((String)this.getExplorer().getValue())) {
            this.getExplorer().selectEntity(((EntityLink)this.getData()).getOrigin(), this.getGroupAnchor(((EntityLink)this.getData()).getDestination().getType()));
        }
        super.initializeSelection(initCallback);
    }

    private String getGroupAnchor(EntityReference.EntityType entityType) {
        return entityType == EntityReference.EntityType.ATTACHMENT || entityType == EntityReference.EntityType.IMAGE ? "Attachments" : null;
    }

    protected void displayError(String errorMessage) {
        this.errorLabel.setText(errorMessage);
        this.errorLabel.setVisible(true);
        if (!this.explorer.getElement().getClassName().contains(FIELD_ERROR_STYLE)) {
            this.explorer.getElement().setClassName(this.explorer.getElement().getClassName() + " " + FIELD_ERROR_STYLE);
        }
        this.mainPanel.refreshHeights();
    }

    protected void hideError() {
        this.errorLabel.setVisible(false);
        String boundary = "\\b";
        this.explorer.getElement().setClassName(this.explorer.getElement().getClassName().replaceAll(boundary + FIELD_ERROR_STYLE + boundary, ""));
        this.mainPanel.refreshHeights();
    }

    public void addNavigationListener(NavigationListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void onRecordDoubleClick(RecordDoubleClickEvent event) {
        this.listeners.fireNavigationEvent(NavigationListener.NavigationDirection.NEXT);
    }

    public void onKeyPress(KeyPressEvent event) {
        if ("Enter".equals(event.getKeyName())) {
            this.listeners.fireNavigationEvent(NavigationListener.NavigationDirection.NEXT);
        }
    }

    protected void updateLinkConfig(final EntityReference selectedEntityReference, final AsyncCallback<Boolean> callback) {
        this.wikiService.getEntityConfig(((EntityLink)this.getData()).getOrigin(), selectedEntityReference, new AsyncCallback<EntityConfig>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(EntityConfig result) {
                ((EntityLink)AbstractExplorerWizardStep.this.getData()).setDestination(selectedEntityReference.clone());
                ((LinkConfig)((EntityLink)AbstractExplorerWizardStep.this.getData()).getData()).setReference(result.getReference());
                ((LinkConfig)((EntityLink)AbstractExplorerWizardStep.this.getData()).getData()).setUrl(result.getUrl());
                callback.onSuccess((Object)true);
            }
        });
    }

    protected WikiServiceAsync getWikiService() {
        return this.wikiService;
    }

    public void onCancel() {
    }

    public String getStepTitle() {
        return this.stepTitle;
    }

    public void setStepTitle(String stepTitle) {
        this.stepTitle = stepTitle;
    }
}

