/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.EnumSet;
import org.xwiki.gwt.user.client.FocusCommand;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkConfigWizardStep
implements WizardStep,
SourcesNavigationEvents,
KeyPressHandler {
    public static final String DEFAULT_STYLE_NAME = "xLinkConfig";
    public static final String INFO_LABEL_STYLE = "xInfoLabel";
    public static final String HELP_LABEL_STYLE = "xHelpLabel";
    public static final String ERROR_LABEL_STYLE = "xErrorMsg";
    protected static final String FIELD_ERROR_STYLE = "xErrorField";
    private EntityLink<LinkConfig> entityLink;
    private final NavigationListenerCollection navigationListeners = new NavigationListenerCollection();
    private final TextBox labelTextBox = new TextBox();
    private final Label labelErrorLabel = new Label();
    private final TextBox tooltipTextBox = new TextBox();
    private CheckBox newWindowCheckBox;
    private final Panel mainPanel = new FlowPanel();
    private final WikiServiceAsync wikiService;

    public LinkConfigWizardStep(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
        this.mainPanel.addStyleName(DEFAULT_STYLE_NAME);
        this.setUpLabelField();
        Label tooltipLabel = new Label(Strings.INSTANCE.linkTooltipLabel());
        tooltipLabel.setStyleName(INFO_LABEL_STYLE);
        Label helpTooltipLabel = new Label(this.getTooltipTextBoxTooltip());
        helpTooltipLabel.setStyleName(HELP_LABEL_STYLE);
        this.tooltipTextBox.addKeyPressHandler((KeyPressHandler)this);
        this.tooltipTextBox.setTitle(this.getTooltipTextBoxTooltip());
        this.mainPanel.add((Widget)tooltipLabel);
        this.mainPanel.add((Widget)helpTooltipLabel);
        this.mainPanel.add((Widget)this.tooltipTextBox);
        this.newWindowCheckBox = new CheckBox(Strings.INSTANCE.linkOpenInNewWindowLabel());
        this.newWindowCheckBox.addStyleName(INFO_LABEL_STYLE);
        Label helpNewWindowLabel = new Label(Strings.INSTANCE.linkOpenInNewWindowHelpLabel());
        helpNewWindowLabel.setStyleName(HELP_LABEL_STYLE);
        this.mainPanel.add((Widget)this.newWindowCheckBox);
        this.mainPanel.add((Widget)helpNewWindowLabel);
    }

    private void setUpLabelField() {
        FlowPanel labelLabel = new FlowPanel();
        labelLabel.setStyleName(INFO_LABEL_STYLE);
        labelLabel.add((Widget)new InlineLabel(Strings.INSTANCE.linkLabelLabel()));
        InlineLabel mandatoryLabel = new InlineLabel(Strings.INSTANCE.mandatory());
        mandatoryLabel.addStyleName("xMandatory");
        labelLabel.add((Widget)mandatoryLabel);
        Label helpLabelLabel = new Label(this.getLabelTextBoxTooltip());
        helpLabelLabel.setStyleName(HELP_LABEL_STYLE);
        this.labelErrorLabel.addStyleName(ERROR_LABEL_STYLE);
        this.labelErrorLabel.setVisible(false);
        this.labelTextBox.addKeyPressHandler((KeyPressHandler)this);
        this.labelTextBox.setTitle(this.getLabelTextBoxTooltip());
        this.mainPanel.add((Widget)labelLabel);
        this.mainPanel.add((Widget)helpLabelLabel);
        this.mainPanel.add((Widget)this.labelErrorLabel);
        this.mainPanel.add((Widget)this.labelTextBox);
    }

    public void init(Object data, final AsyncCallback<?> callback) {
        this.entityLink = (EntityLink)data;
        LinkConfig linkConfig = this.entityLink.getData();
        if (linkConfig.isReadOnlyLabel()) {
            this.wikiService.parseLinkReference(linkConfig.getLabelText(), EntityReference.EntityType.IMAGE, this.entityLink.getOrigin(), new AsyncCallback<EntityReference>(){

                public void onFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onSuccess(EntityReference result) {
                    LinkConfigWizardStep.this.init(result, callback);
                }
            });
        } else {
            this.init(null, callback);
        }
    }

    private void init(EntityReference imageReference, AsyncCallback<?> callback) {
        LinkConfig linkConfig = this.entityLink.getData();
        this.labelTextBox.setText(imageReference != null ? imageReference.getFileName() : linkConfig.getLabelText());
        this.labelTextBox.setEnabled(!linkConfig.isReadOnlyLabel());
        this.tooltipTextBox.setText(linkConfig.getTooltip() == null ? "" : linkConfig.getTooltip());
        this.newWindowCheckBox.setValue(Boolean.valueOf(linkConfig.isOpenInNewWindow()));
        this.hideErrors();
        callback.onSuccess(null);
        this.setFocus();
    }

    protected void setFocus() {
        DeferredCommand.addCommand((Command)new FocusCommand((Focusable)(this.labelTextBox.isEnabled() ? this.labelTextBox : this.tooltipTextBox)));
    }

    public Widget display() {
        return this.mainPanel;
    }

    public Panel getMainPanel() {
        return this.mainPanel;
    }

    protected TextBox getLabelTextBox() {
        return this.labelTextBox;
    }

    protected LinkConfig getLinkConfig() {
        return this.entityLink.getData();
    }

    protected String getLabelTextBoxTooltip() {
        return Strings.INSTANCE.linkConfigLabelTextBoxTooltip();
    }

    protected String getTooltipTextBoxTooltip() {
        return Strings.INSTANCE.linkConfigTooltipTextBoxTooltip();
    }

    public TextBox getTooltipTextBox() {
        return this.tooltipTextBox;
    }

    public CheckBox getNewWindowCheckBox() {
        return this.newWindowCheckBox;
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        this.hideErrors();
        if (!this.validateForm()) {
            async.onSuccess((Object)false);
            this.setFocus();
        } else {
            this.saveForm();
            async.onSuccess((Object)true);
        }
    }

    protected boolean validateForm() {
        if (this.labelTextBox.getText().trim().length() == 0) {
            this.displayLabelError(Strings.INSTANCE.linkNoLabelError());
            return false;
        }
        return true;
    }

    protected void saveForm() {
        LinkConfig linkConfig = this.getLinkConfig();
        if (!linkConfig.isReadOnlyLabel() && !this.labelTextBox.getText().trim().equals(linkConfig.getLabelText().trim())) {
            linkConfig.setLabel(this.labelTextBox.getText().trim());
            linkConfig.setLabelText(this.labelTextBox.getText().trim());
        }
        linkConfig.setTooltip(this.getTooltipTextBox().getText());
        linkConfig.setOpenInNewWindow(this.getNewWindowCheckBox().getValue());
    }

    public void onCancel() {
    }

    public Object getResult() {
        return this.entityLink;
    }

    public String getNextStep() {
        return null;
    }

    public String getStepTitle() {
        return Strings.INSTANCE.linkConfigTitle();
    }

    public EnumSet<NavigationListener.NavigationDirection> getValidDirections() {
        return EnumSet.of(NavigationListener.NavigationDirection.FINISH, NavigationListener.NavigationDirection.CANCEL, NavigationListener.NavigationDirection.PREVIOUS);
    }

    public String getDirectionName(NavigationListener.NavigationDirection direction) {
        switch (direction) {
            case FINISH: {
                return Strings.INSTANCE.linkCreateLinkButton();
            }
        }
        return null;
    }

    public NavigationListener.NavigationDirection getDefaultDirection() {
        return NavigationListener.NavigationDirection.FINISH;
    }

    public void addNavigationListener(NavigationListener listener) {
        this.navigationListeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.navigationListeners.remove((Object)listener);
    }

    public void onKeyPress(KeyPressEvent event) {
        if (event.getNativeEvent().getKeyCode() == 13) {
            this.navigationListeners.fireNavigationEvent(this.getDefaultDirection());
        }
    }

    protected void displayLabelError(String errorMessage) {
        this.labelErrorLabel.setText(errorMessage);
        this.labelErrorLabel.setVisible(true);
        this.labelTextBox.addStyleName(FIELD_ERROR_STYLE);
    }

    protected void hideErrors() {
        this.labelErrorLabel.setVisible(false);
        this.labelTextBox.removeStyleName(FIELD_ERROR_STYLE);
    }

    protected Label getLabelErrorLabel() {
        return this.labelErrorLabel;
    }
}

