/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.table;

import java.util.ArrayList;
import java.util.List;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.table.TableFeature;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.DeleteCol;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.DeleteRow;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.DeleteTable;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.InsertColAfter;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.InsertColBefore;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.InsertRowAfter;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.InsertRowBefore;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.InsertTable;
import org.xwiki.gwt.wysiwyg.client.plugin.table.ui.TableMenuExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePlugin
extends AbstractPlugin {
    private final List<TableFeature> features = new ArrayList<TableFeature>();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");
    private TableMenuExtension menuExtension;

    private void addFeature(RichTextArea rta, TableFeature feature) {
        rta.getCommandManager().registerCommand(feature.getCommand(), (Executable)feature);
        this.features.add(feature);
    }

    @Override
    public void init(RichTextArea rta, Config config) {
        super.init(rta, config);
        this.addFeature(rta, new InsertTable(this));
        this.addFeature(rta, new InsertRowBefore(this));
        this.addFeature(rta, new InsertRowAfter(this));
        this.addFeature(rta, new DeleteRow(this));
        this.addFeature(rta, new InsertColBefore(this));
        this.addFeature(rta, new InsertColAfter(this));
        this.addFeature(rta, new DeleteCol(this));
        this.addFeature(rta, new DeleteTable(this));
        this.menuExtension = new TableMenuExtension(this);
        this.getUIExtensionList().add(this.menuExtension);
        rta.getDocument().execCommand("enableInlineTableEditing", "false");
        this.getUIExtensionList().add(this.toolBarExtension);
    }

    public List<TableFeature> getFeatures() {
        return this.features;
    }

    @Override
    public void destroy() {
        for (TableFeature feature : this.features) {
            feature.destroy();
        }
        this.features.clear();
        this.toolBarExtension.clearFeatures();
        super.destroy();
    }
}

