/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.user.client.ActionHandler;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.NativeActionHandler;
import org.xwiki.gwt.user.client.NativeAsyncCallback;
import org.xwiki.gwt.user.client.internal.DefaultConfig;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManagerApi;
import org.xwiki.gwt.wysiwyg.client.WysiwygEditor;
import org.xwiki.gwt.wysiwyg.client.WysiwygEditorDebugger;
import org.xwiki.gwt.wysiwyg.client.WysiwygEditorFactory;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverter;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverterAsync;

public class WysiwygEditorApi {
    public static final Command SUBMIT = new Command("submit");
    private WysiwygEditor editor;
    private CommandManagerApi commandManagerApi;
    private final HTMLConverterAsync converter = (HTMLConverterAsync)GWT.create(HTMLConverter.class);

    public WysiwygEditorApi(org.xwiki.gwt.dom.client.JavaScriptObject jsConfig) {
        if (!WysiwygEditorApi.isRichTextEditingSupported()) {
            return;
        }
        DefaultConfig config = new DefaultConfig(jsConfig);
        Element hook = DOM.getElementById((String)config.getParameter("hookId"));
        if (hook == null) {
            return;
        }
        final Element container = DOM.createDiv();
        String containerId = hook.getId() + "_container" + Math.round(Math.random() * 1000.0);
        container.setId(containerId);
        hook.getParentElement().insertBefore((Node)container, (Node)hook);
        this.editor = WysiwygEditorFactory.getInstance().newEditor((Config)config);
        if (Boolean.TRUE.toString().equals(this.editor.getConfig().getParameter("debug", "false"))) {
            RootPanel.get((String)containerId).add((Widget)new WysiwygEditorDebugger(this.editor));
        } else {
            RootPanel.get((String)containerId).add(this.editor.getUI());
        }
        Window.addCloseHandler((CloseHandler)new CloseHandler<Window>(){

            public void onClose(CloseEvent<Window> event) {
                if (WysiwygEditorApi.this.editor != null) {
                    WysiwygEditorApi.this.editor.destroy();
                }
                if (container.getParentNode() != null) {
                    container.getParentNode().removeChild((Node)container);
                }
            }
        });
    }

    public static boolean isRichTextEditingSupported() {
        RichTextArea textArea = new RichTextArea(null);
        return textArea.getFormatter() != null;
    }

    public void release() {
        if (this.editor != null) {
            Widget container = this.editor.getUI();
            while (container.getParent() != null) {
                container = container.getParent();
            }
            RootPanel.detachNow((Widget)container);
            this.editor = null;
        }
    }

    public Element getPlainTextArea() {
        return this.editor == null ? null : this.editor.getPlainTextEditor().getTextArea().getElement();
    }

    public Element getRichTextArea() {
        return this.editor == null ? null : this.editor.getRichTextEditor().getTextArea().getElement();
    }

    public void getSourceText(org.xwiki.gwt.dom.client.JavaScriptObject onSuccess, org.xwiki.gwt.dom.client.JavaScriptObject onFailure) {
        NativeAsyncCallback callback = new NativeAsyncCallback(onSuccess, onFailure);
        if (this.editor.getRichTextEditor().getTextArea().isEnabled()) {
            this.editor.getRichTextEditor().getTextArea().getCommandManager().execute(SUBMIT);
            this.converter.fromHTML(this.editor.getRichTextEditor().getTextArea().getCommandManager().getStringValue(SUBMIT), this.editor.getConfig().getParameter("syntax", "xhtml/1.0"), (AsyncCallback<String>)callback);
        } else {
            callback.onSuccess((Object)this.editor.getPlainTextEditor().getTextArea().getText());
        }
    }

    public CommandManagerApi getCommandManagerApi() {
        if (this.commandManagerApi == null) {
            this.commandManagerApi = CommandManagerApi.newInstance((CommandManager)this.editor.getRichTextEditor().getTextArea().getCommandManager());
        }
        return this.commandManagerApi;
    }

    public HandlerRegistration addActionHandler(String actionName, org.xwiki.gwt.dom.client.JavaScriptObject jsHandler) {
        if (this.editor != null) {
            return this.editor.getRichTextEditor().getTextArea().addActionHandler(actionName, (ActionHandler)new NativeActionHandler((JavaScriptObject)jsHandler));
        }
        return null;
    }

    public static native void publish();
}

