/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.diff;

import java.util.ArrayList;
import java.util.Arrays;
import org.xwiki.gwt.wysiwyg.client.diff.DiffAlgorithm;
import org.xwiki.gwt.wysiwyg.client.diff.DifferentiationFailedException;
import org.xwiki.gwt.wysiwyg.client.diff.Revision;
import org.xwiki.gwt.wysiwyg.client.diff.ToString;
import org.xwiki.gwt.wysiwyg.client.diff.myers.MyersDiff;

public class Diff
extends ToString {
    public static final String NL = " ";
    public static final String RCS_EOL = " ";
    protected Object[] orig;
    protected DiffAlgorithm algorithm;

    public Diff() {
        this(new Object[0]);
    }

    public Diff(Object[] original) {
        this(original, null);
    }

    public Diff(Object[] original, DiffAlgorithm algorithm) {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        this.orig = original;
        this.algorithm = algorithm != null ? algorithm : this.defaultAlgorithm();
    }

    protected DiffAlgorithm defaultAlgorithm() {
        return new MyersDiff();
    }

    public static Revision diff(Object[] orig, Object[] rev) throws DifferentiationFailedException {
        if (orig == null || rev == null) {
            throw new IllegalArgumentException();
        }
        return Diff.diff(orig, rev, null);
    }

    public static Revision diff(Object[] orig, Object[] rev, DiffAlgorithm algorithm) throws DifferentiationFailedException {
        if (orig == null || rev == null) {
            throw new IllegalArgumentException();
        }
        return new Diff(orig, algorithm).diff(rev);
    }

    public Revision diff(Object[] rev) throws DifferentiationFailedException {
        if (this.orig.length == 0 && rev.length == 0) {
            return new Revision();
        }
        return this.algorithm.diff(this.orig, rev);
    }

    public static boolean compare(Object[] orig, Object[] rev) {
        if (orig.length != rev.length) {
            return false;
        }
        for (int i = 0; i < orig.length; ++i) {
            if (orig[i].equals(rev[i])) continue;
            return false;
        }
        return true;
    }

    public static Object[] editAll(Object[] text) {
        Object[] result = new String[text.length];
        for (int i = 0; i < text.length; ++i) {
            result[i] = text[i] + " <edited>";
        }
        return result;
    }

    public static Object[] randomEdit(Object[] text) {
        return Diff.randomEdit(text, text.length);
    }

    public static Object[] randomEdit(Object[] text, long seed) {
        return text;
    }

    public static Object[] shuffle(Object[] text) {
        return Diff.shuffle(text, text.length);
    }

    public static Object[] shuffle(Object[] text, long seed) {
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList(text));
        return result.toArray();
    }
}

