/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.color;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.wysiwyg.client.plugin.color.ColorPalette;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorPicker
extends PopupPanel
implements SelectionHandler<String> {
    public ColorPicker(ColorPalette palette) {
        super(true, false);
        this.addStyleName("xColorPicker");
        palette.addSelectionHandler(this);
        this.setWidget((Widget)palette);
    }

    public void onSelection(SelectionEvent<String> event) {
        if (event.getSource() == this.getWidget()) {
            this.hide();
        }
    }

    protected ColorPalette getColorPalette() {
        return (ColorPalette)this.getWidget();
    }

    public String getColor() {
        return this.getColorPalette().getSelectedColor();
    }

    public void setColor(String color) {
        this.getColorPalette().setSelectedColor(ColorPicker.convertToHex(color));
    }

    public static String convertToHex(String color) {
        if (color == null) {
            return null;
        }
        try {
            String hex = Integer.toHexString(Integer.parseInt(color));
            char[] padding = new char[Math.max(0, 6 - hex.length())];
            for (int i = 0; i < padding.length; ++i) {
                padding[i] = 48;
            }
            hex = String.valueOf(padding) + hex;
            hex = '#' + hex.substring(4) + hex.substring(2, 4) + hex.substring(0, 2);
            return hex.toUpperCase();
        }
        catch (NumberFormatException e) {
            String rgbRegExp = "^rgb\\s*\\(\\s*([0-9]+).*,\\s*([0-9]+).*,\\s*([0-9]+).*\\)$";
            String[] rgb = color.toLowerCase().replaceAll(rgbRegExp, "$1,$2,$3").split(",");
            if (rgb.length == 3) {
                StringBuffer hex = new StringBuffer("#");
                for (int i = 0; i < rgb.length; ++i) {
                    String channel = Integer.toHexString(Integer.parseInt(rgb[i]));
                    if (channel.length() == 1) {
                        channel = '0' + channel;
                    }
                    hex.append(channel);
                }
                return hex.toString().toUpperCase();
            }
            return color;
        }
    }
}

