/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.history.internal;

import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xwiki.gwt.dom.client.DOMUtils;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.PasteEvent;
import org.xwiki.gwt.dom.client.PasteHandler;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.dom.client.Text;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.wysiwyg.client.plugin.history.History;
import org.xwiki.gwt.wysiwyg.client.plugin.history.internal.Entry;
import org.xwiki.gwt.wysiwyg.client.plugin.history.internal.KeyboardAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHistory
implements History,
KeyDownHandler,
PasteHandler,
CommandListener {
    private static final List<Command> IGNORED_COMMANDS = Arrays.asList(Command.UNDO, Command.REDO, new Command("submit"), new Command("update"), new Command("reset"), new Command("enable"));
    private final RichTextArea textArea;
    private final int capacity;
    private Entry oldestEntry;
    private Entry currentEntry;
    private KeyboardAction previousKeyboardAction;

    public DefaultHistory(RichTextArea textArea, int capacity) {
        assert (capacity > 1);
        this.capacity = capacity;
        this.textArea = textArea;
        textArea.addPasteHandler((PasteHandler)this);
        textArea.addKeyDownHandler((KeyDownHandler)this);
        textArea.getCommandManager().addCommandListener((CommandListener)this);
    }

    @Override
    public boolean canRedo() {
        return this.textArea.getDocument() != null && this.currentEntry != null && this.currentEntry.getNextEntry() != null && !this.isDirty();
    }

    @Override
    public boolean canUndo() {
        return this.textArea.getDocument() != null && this.currentEntry != null && (this.currentEntry.getPreviousEntry() != null || this.isDirty());
    }

    @Override
    public void redo() {
        if (this.canRedo()) {
            this.load(this.currentEntry.getNextEntry());
        }
    }

    @Override
    public void undo() {
        if (this.canUndo()) {
            if (!this.canRedo()) {
                this.save();
            }
            this.load(this.currentEntry.getPreviousEntry());
        }
    }

    private boolean isFull() {
        int entryCount = 0;
        for (Entry entry = this.oldestEntry; entry != null; entry = entry.getNextEntry()) {
            ++entryCount;
        }
        return entryCount >= this.capacity;
    }

    private boolean isEmpty() {
        return this.oldestEntry == null;
    }

    private boolean isDirty() {
        return this.currentEntry != null && !this.currentEntry.getContent().equals(this.textArea.getHTML());
    }

    private void load(Entry entry) {
        this.currentEntry = entry;
        this.textArea.setHTML(entry.getContent());
        Document doc = this.textArea.getDocument();
        Range range = doc.createRange();
        range.setStart(DefaultHistory.getNode(doc, entry.getStartPath()), entry.getStartPath().get(0).intValue());
        range.setEnd(DefaultHistory.getNode(doc, entry.getEndPath()), entry.getEndPath().get(0).intValue());
        Selection selection = doc.getSelection();
        selection.removeAllRanges();
        selection.addRange(range);
    }

    private static List<Integer> getPath(Node node, int offset) {
        ArrayList<Integer> path = new ArrayList<Integer>();
        switch (node.getNodeType()) {
            case 4: 
            case 8: {
                path.add(offset);
                break;
            }
            case 3: {
                path.add(Text.as((Node)node).getOffset() + offset);
                break;
            }
            case 1: {
                if (offset == node.getChildNodes().getLength()) {
                    path.add(DOMUtils.getInstance().getNormalizedChildCount(node));
                    break;
                }
                path.add(DOMUtils.getInstance().getNormalizedNodeIndex(node.getChildNodes().getItem(offset)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type!");
            }
        }
        Node ancestor = node;
        while (ancestor.getParentNode() != null) {
            path.add(DOMUtils.getInstance().getNormalizedNodeIndex(ancestor));
            ancestor = ancestor.getParentNode();
        }
        return path;
    }

    private static Node getNode(Document doc, List<Integer> path) {
        Document node = doc;
        for (int i = path.size() - 1; i > 1; --i) {
            node = node.getChildNodes().getItem(path.get(i).intValue());
        }
        assert (node.getNodeType() == 1);
        if (node.getChildNodes().getLength() == 0) {
            node.appendChild((Node)node.getOwnerDocument().createTextNode(""));
        }
        return node.getChildNodes().getItem(path.get(1).intValue());
    }

    private void save() {
        if (!this.isEmpty() && !this.isDirty() || this.textArea.getDocument() == null) {
            return;
        }
        Selection selection = this.textArea.getDocument().getSelection();
        if (selection.getRangeCount() == 0) {
            return;
        }
        Range range = selection.getRangeAt(0);
        List<Integer> startPath = DefaultHistory.getPath(range.getStartContainer(), range.getStartOffset());
        List<Integer> endPath = DefaultHistory.getPath(range.getEndContainer(), range.getEndOffset());
        Entry newestEntry = new Entry(this.textArea.getHTML(), startPath, endPath);
        if (this.currentEntry != null) {
            this.currentEntry.setNextEntry(newestEntry);
        }
        newestEntry.setPreviousEntry(this.currentEntry);
        this.currentEntry = newestEntry;
        if (this.oldestEntry == null) {
            this.oldestEntry = this.currentEntry;
        }
        if (this.isFull()) {
            this.oldestEntry = this.oldestEntry.getNextEntry();
            this.oldestEntry.setPreviousEntry(null);
        }
    }

    public void onKeyDown(KeyDownEvent event) {
        if (event.getSource() == this.textArea && !event.isControlKeyDown()) {
            KeyboardAction currentKeyboardAction = KeyboardAction.valueOf(event.getNativeKeyCode());
            if (this.isEmpty() || currentKeyboardAction != this.previousKeyboardAction) {
                this.save();
            }
            this.previousKeyboardAction = currentKeyboardAction;
        }
    }

    public void onPaste(PasteEvent event) {
        if (event.getSource() == this.textArea) {
            this.save();
            this.previousKeyboardAction = null;
        }
    }

    public boolean onBeforeCommand(CommandManager sender, Command command, String param) {
        if (sender == this.textArea.getCommandManager() && !IGNORED_COMMANDS.contains(command)) {
            this.save();
            this.previousKeyboardAction = null;
        }
        return false;
    }

    public void onCommand(CommandManager sender, Command command, String param) {
    }
}

