/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image;

import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Style;
import org.xwiki.gwt.user.client.EscapeUtils;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.AbstractInsertElementExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigDOMReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageConfigDOMWriter
implements AbstractInsertElementExecutable.ConfigDOMWriter<ImageConfig, ImageElement> {
    private static final String PIXELS_OR_PERCENT = "^\\+?[1-9]\\d*(\\.\\d+)?(px|%)?$";
    private final ImageConfigDOMReader configDOMReader = new ImageConfigDOMReader();

    public void write(ImageConfig imageConfig, ImageElement image) {
        this.updateMetaData(image, imageConfig.getReference());
        image.setSrc(imageConfig.getUrl());
        image.setAlt(imageConfig.getAltText());
        this.updateDimension(image, "width", imageConfig.getWidth());
        this.updateDimension(image, "height", imageConfig.getHeight());
        this.updateAlignment(image, imageConfig.getAlignment());
    }

    private void updateMetaData(ImageElement image, String reference) {
        Document document = (Document)image.getOwnerDocument();
        DocumentFragment metaData = document.createDocumentFragment();
        metaData.appendChild(document.createComment("startimage:" + EscapeUtils.escapeComment((String)reference)));
        metaData.appendChild((Node)document.createTextNode("org.xwiki.gwt.dom.client.Element#placeholder"));
        metaData.appendChild(document.createComment("stopimage"));
        Element.as((Node)image).setMetaData(metaData);
    }

    private void updateDimension(ImageElement image, String dimension, String value) {
        if (StringUtils.isEmpty((String)value)) {
            image.removeAttribute(dimension);
            image.getStyle().clearProperty(dimension);
        } else if (value.matches(PIXELS_OR_PERCENT)) {
            String computedValue = image.getPropertyString(dimension);
            if (!value.equals(computedValue) && !value.equals(computedValue + Style.Unit.PX.getType())) {
                image.setAttribute(dimension, value);
                image.getStyle().clearProperty(dimension);
            }
        } else {
            image.removeAttribute(dimension);
            image.getStyle().setProperty(dimension, value);
        }
    }

    private void updateAlignment(ImageElement image, ImageConfig.ImageAlignment alignment) {
        ImageConfig.ImageAlignment currentAlignment = this.configDOMReader.readImageAlignment(image);
        if (!(currentAlignment == null || alignment != null && alignment.equals((Object)currentAlignment))) {
            this.removeImageAlignment(image, currentAlignment);
        }
        if (alignment != null) {
            this.addImageAlignment(image, alignment);
        }
    }

    private void removeImageAlignment(ImageElement image, ImageConfig.ImageAlignment alignment) {
        switch (alignment) {
            case TOP: 
            case MIDDLE: 
            case BOTTOM: {
                image.getStyle().clearProperty(Style.VERTICAL_ALIGN.getJSName());
                break;
            }
            case LEFT: 
            case RIGHT: {
                image.getStyle().clearFloat();
                break;
            }
            case CENTER: {
                image.getStyle().clearDisplay();
                image.getStyle().clearMarginLeft();
                image.getStyle().clearMarginRight();
                break;
            }
        }
    }

    private void addImageAlignment(ImageElement image, ImageConfig.ImageAlignment alignment) {
        switch (alignment) {
            case TOP: {
                image.getStyle().setVerticalAlign(Style.VerticalAlign.TOP);
                break;
            }
            case MIDDLE: {
                image.getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
                break;
            }
            case BOTTOM: {
                image.getStyle().setVerticalAlign(Style.VerticalAlign.BOTTOM);
                break;
            }
            case LEFT: {
                image.getStyle().setFloat(Style.Float.LEFT);
                break;
            }
            case RIGHT: {
                image.getStyle().setFloat(Style.Float.RIGHT);
                break;
            }
            case CENTER: {
                image.getStyle().setDisplay(Style.Display.BLOCK);
                image.getStyle().setProperty(Style.MARGIN_LEFT.getJSName(), "auto");
                image.getStyle().setProperty(Style.MARGIN_RIGHT.getJSName(), "auto");
                break;
            }
        }
    }
}

