/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.ui;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.xwiki.gwt.user.client.ui.ListItem;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.ImageWizard;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractEntityListSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentPageImageSelectorWizardStep
extends AbstractEntityListSelectorWizardStep<ImageConfig, Attachment>
implements SelectionHandler<ListItem<Attachment>> {
    private final ListItem<Attachment> clearFloatsListItem;
    private final boolean useLinkDestination;

    public CurrentPageImageSelectorWizardStep(WikiServiceAsync wikiService, boolean useLinkDestination) {
        super(wikiService);
        this.useLinkDestination = useLinkDestination;
        this.getMainPanel().addStyleName("xImagesSelector");
        this.clearFloatsListItem = new ListItem();
        this.clearFloatsListItem.setStyleName("clearfloats");
        this.getList().addSelectionHandler((SelectionHandler)this);
    }

    @Override
    protected String getSelectHelpLabel() {
        return Strings.INSTANCE.imageSelectImageHelpLabel();
    }

    @Override
    protected String getSelectErrorMessage() {
        return Strings.INSTANCE.imageNoImageSelectedError();
    }

    @Override
    protected void fetchData(AsyncCallback<List<Attachment>> callback) {
        EntityReference currentPage = this.useLinkDestination ? ((EntityLink)this.getData()).getDestination() : ((EntityLink)this.getData()).getOrigin();
        this.getWikiService().getImageAttachments(currentPage, callback);
    }

    @Override
    protected void fillList(List<Attachment> attachments, Attachment selectedAttachment) {
        super.fillList(attachments, selectedAttachment);
        this.getList().addItem(this.clearFloatsListItem);
    }

    public String getNextStep() {
        if (this.getSelectedItem() != null && this.getSelectedItem().getData() == null) {
            return ImageWizard.ImageWizardStep.IMAGE_UPLOAD.toString();
        }
        return ImageWizard.ImageWizardStep.IMAGE_CONFIG.toString();
    }

    public String getStepTitle() {
        return Strings.INSTANCE.imageSelectImageTitle();
    }

    @Override
    protected ListItem<Attachment> getListItem(Attachment image) {
        ListItem imageItem = new ListItem();
        imageItem.setData((Object)image);
        Image htmlImage = new Image(image.getUrl() + "?width=135");
        htmlImage.setTitle(image.getReference().getFileName());
        FlowPanel previewPanel = new FlowPanel();
        previewPanel.addStyleName("xImagePreview");
        previewPanel.add((Widget)htmlImage);
        imageItem.add((Widget)previewPanel);
        return imageItem;
    }

    @Override
    protected ListItem<Attachment> getNewOptionListItem() {
        ListItem newImageOption = new ListItem();
        newImageOption.setData(null);
        FlowPanel newOptionPanel = new FlowPanel();
        newOptionPanel.addStyleName("xNewImagePreview");
        Label newOptionLabel = new Label(Strings.INSTANCE.imageUploadNewFileLabel());
        newOptionPanel.add((Widget)newOptionLabel);
        newImageOption.add((Widget)newOptionPanel);
        return newImageOption;
    }

    public void onSelection(SelectionEvent<ListItem<Attachment>> event) {
        if (event.getSelectedItem() == this.clearFloatsListItem) {
            this.getList().setSelectedItem(this.getList().getItem(this.getList().getItemCount() - 2));
        }
    }
}

